<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Pancake
 * A simple, fast, self-hosted invoicing application
 *
 * @package        Pancake
 * @author         Pancake Dev Team
 * @copyright      Copyright (c) 2010, Pancake Payments
 * @license        http://pancakeapp.com/license
 * @link           http://pancakeapp.com
 * @since          Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * The Key Model
 *
 * @subpackage    Models
 * @category      Key
 */
class Key_m extends Pancake_Model {
    /**
     * @var string    The name of the settings table
     */
    protected $table = 'keys';

    /**
     * @var bool    Tells the model to skip auto validation
     */
    protected $skip_validation = true;

    public function update_keys($keys, $notes) {
        $this->db->trans_begin();

        foreach ($keys as $id => $key) {
            // Missing key
            if (!$key) {
                $this->db->delete($this->table, array('id' => $id));
            }

            $this->db->where('id', $id)->update($this->table, array(
                'key' => $key,
                'note' => $notes[$id],
            ));
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        }

        $this->db->trans_commit();
        return true;
    }

    public function insert_keys($keys, $notes) {
        $this->db->trans_begin();

        foreach ($keys as $id => $key) {
            if ($key) {
                $this->db->insert($this->table, array(
                    'key' => $key,
                    'note' => $notes[$id],
                    'level' => 0,
                    'date_created' => now()->timestamp,
                ));
            }
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        }

        $this->db->trans_commit();
        return true;
    }
}

/* End of file: key_m.php */