<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Pancake
 *
 * A simple, fast, self-hosted invoicing application.
 *
 * This is the Spanish translation for Pancake.
 *
 * @package     Pancake
 * @author      Albert Calvet <sefirot22@gmail.com> - https://github.com/AlbertCalvet
 * @author      Bruno De Barros <bruno@terraduo.com> - https://terraduo.com
 * @author      Francisco arenas <francisco.arenas@dospuntocero.cl> - dospuntocero.cl
 * @author      Pancake Payments <support@pancakeapp.com> - https://www.pancakeapp.com
 * @copyright   Copyright (c) 2016, Pancake Payments
 * @license     https://www.pancakeapp.com/license
 * @link        https://www.pancakeapp.com
 * @since       Version 4.11.22
 */

// ------------------------------------------------------------------------

$lang = array (
  'global:overview' => 'Resumen',
  'global:error' => 'Error',
  'global:pancakeby7am' => 'Pancake :1',
  'global:allrelatedmediacopyright' => 'Pancake y todos los medios relacionados tienen Copyright :1 :2',
  'global:insecure_action' => 'Acción insegura se intentó pero fue atrapada',
  'global:disabled_in_demo' => 'Algunas funciones de esta página están deshabilitadas para la demo.',
  'global:estimates' => 'Presupuestos',
  'global:estimate' => 'Presupuesto',
  'global:incomplete_tasks' => 'Tareas incompletas',
  'global:completed_tasks' => 'Tareas completas',
  'global:projects' => 'Proyectos',
  'global:tickets' => 'Tickets',
  'global:project' => 'Proyecto',
  'global:upload_failed' => 'Hubo un problema al subir el archivo. Por favor, vuelva a intentarlo. Si el problema persiste, póngase en contacto con support@pancakeapp.com.',
  'global:upload_not_allowed' => 'El tipo de archivo del archivo que estaba tratando de subir no está permitido. Si necesita cargar un archivo de ese tipo, por favor comprimirlo en un archivo .zip o cualquier otro formato de archivo que usted podría encontrar apropiado.',
  'global:copied' => 'Copiado!',
  'global:sentbutunpaid' => 'Pendiente (Enviado, pero sin pagar)',
  'global:task' => 'Tarea',
  'global:clients' => 'Clientes',
  'global:access_denied' => 'Acceso negado',
  'global:users' => 'Usuario',
  'global:send_to_client' => 'Enviado al cliente',
  'global:couldnotsendemail' => 'No se pudo enviar el e-mail. Favor verificar la configuracion.',
  'global:emailsent' => 'El correo electrónico ha sido enviado!',
  'global:yes' => 'Si',
  'global:no' => 'No',
  'global:notyetsent' => 'No enviado al cliente',
  'global:dontshowagain' => 'No mostrar nuevamente',
  'global:enable' => 'Habilitar',
  'global:is_enabled' => 'Habilitado?',
  'global:is_completed' => 'Completado?',
  'global:Y' => 'S',
  'global:N' => 'N',
  'global:notes' => 'Notas',
  'global:description' => 'Descripción',
  'global:backtoadmin' => 'Volver al Admin',
  'global:type' => 'Tipo',
  'global:name' => 'Nombre',
  'global:first_name' => 'Primer nombre',
  'global:last_name' => 'Apellido',
  'global:company' => 'Compañía',
  'global:for' => 'para',
  'global:from' => 'de',
  'global:phone' => 'Teléfono',
  'global:email' => 'Email',
  'global:contacts' => 'Contactos',
  'global:week' => 'Semanalmente',
  'global:na' => 'N/A',
  'global:quarterly' => 'Trimestralmente',
  'global:every_six_months' => 'Cada 6 meses',
  'global:statistics' => 'Estadísticas',
  'global:biyearly' => 'Cada 2 años',
  'global:month' => 'Mensualmente',
  'global:year' => 'Anualmente',
  'global:fax' => 'Fax',
  'global:mobile' => 'Móvil',
  'global:address' => 'Dirección',
  'global:api_key' => 'Llave de API',
  'global:website' => 'Sitio',
  'global:action' => 'Acción',
  'global:items' => 'Items',
  'global:reusableinvoiceitems' => 'Items de factura reutilizables',
  'global:reusableinvoiceitems_description' => 'Deberías utilizar Elementos de factura reutilizables cuando se desea volver a utilizar el mismo artículo en diferentes facturas. Para utilizarlos al crear o editar una factura, simplemente comienza a escribir el nombre del elemento que ha guardado y se autocompletarán los detalles del elemento para usted.',
  'global:create_invoice_estimate' => 'Crear facturas y presupuestos para recolectar dinero.',
  'global:createinvoice' => 'Crear factura',
  'global:paid' => 'Pagado',
  'global:unpaid' => 'Sin pagar',
  'global:overdue' => 'Atrasado',
  'global:time_entries' => 'Entradas de tiempo',
  'global:invoices' => 'Facturas',
  'global:invoice' => 'Factura',
  'global:tasks' => 'Tareas',
  'global:dashboard' => 'Panel de control',
  'global:settings' => 'Ajustes',
  'global:plugins' => 'Plugins',
  'global:installed' => 'Instalado',
  'global:changepassword' => 'Cambiar Password',
  'global:logout' => 'Salir',
  'global:status' => 'Estatus',
  'global:client' => 'Cliente',
  'global:user' => 'Usuario',
  'global:title' => 'Título',
  'global:subtitle' => 'Subtítulo',
  'global:to' => 'A (separar múltiples direcciones con una coma)',
  'global:subject' => 'Asunto',
  'global:thanks' => 'Gracias!',
  'global:proposals' => 'Propuestas',
  'global:proposal' => 'Propuesta',
  'global:reports' => 'Reportes',
  'global:item' => 'Item',
  'global:report' => 'Reporte',
  'global:saveandinsert' => 'Guardar e insertar',
  'global:details' => 'Detalles',
  'global:license_key' => 'Llave de licencia',
  'global:version' => 'Version :1',
  'global:content' => 'Contenido',
  'global:add' => 'Agregar',
  'global:edit' => 'Editar',
  'global:resend' => 'Re enviar',
  'global:sent' => 'Enviado',
  'global:not_sent' => 'No enviado',
  'global:view' => 'Ver',
  'global:delete' => 'Borrar',
  'global:remove' => 'Remover',
  'global:sort' => 'Ordenar',
  'global:deleteitem' => 'Borrar ítem',
  'global:dragtoreorder' => 'Arrastrar para reordenar',
  'global:start' => 'Comenzasr',
  'global:stop' => 'Parar',
  'global:start_timer' => 'Iniciar temporizador',
  'estimates:create' => 'Crear Presupuesto',
  'global:stop_timer' => 'Parar temporizador',
  'global:created' => 'Creado',
  'global:updated' => 'Actualizado',
  'global:update' => 'Actualizar',
  'global:update_available' => ':1 Actualización disponible',
  'global:updates_available' => ':1 Actualizaciones disponibles',
  'global:downloadpdf' => 'Descargar PDF',
  'global:yesdelete' => 'Si, borrar!',
  'global:confirm_emphisised' => 'No hay vuelta atrás!',
  'global:color' => 'Color',
  'global:save' => 'Guardar',
  'global:unknown' => 'Desconocido',
  'global:upload_ini_size' => 'El archivo que has subido excede el límite de tamaño impuesto por la instalación de PHP.',
  'global:upload_error' => 'Ocurrió un problema al subir el archivo. Por favor, inténtalo de nuevo.',
  'global:recurring' => 'Recurrente',
  'global:unsent' => 'Sin enviar',
  'global:converttoproject' => 'Convertir a Proyecto',
  'global:converttoinvoice' => 'Convertir a Factura',
  'global:viewpdf' => 'Ver PDF',
  'global:duplicate' => 'Duplicar',
  'global:urltosend' => 'Aquí está la url para enviar:',
  'global:copytoclipboard' => 'Copiar al portapapeles',
  'global:you_need_pancake_cron_job' => 'Para utilizar facturas recurrentes, debe configurar el <a href="https://www.pancakeapp.com/documentation/cron" target="_blank">Pancake Cron Job</a>.',
  'global:quick_links' => 'Enlaces rápidos',
  'global:view_all' => 'Ver todo',
  'global:deleted' => 'Borrados',
  'global:add_more' => 'Agregar más',
  'global:upload_files' => 'Subir archivos',
  'global:optional_increment' => '<strong>Opcional</strong> - se autoincrementará',
  'login:ahoy' => 'ki wa!',
  'login:readytodothis' => 'Listo??',
  'login:sup' => 'kipa shushetumare?',
  'global:actions' => 'Acciones',
  'global:select' => '--- Seleccionar ---',
  'global:mark_as_unanswered' => 'Marcar sin respuesta',
  'global:mark_as_accepted' => 'Marcar como aceptado',
  'global:mark_as_rejected' => 'Marcar como rechazado',
  'global:reject_estimate' => 'Rechazar presupuesto',
  'global:accept_estimate' => 'Aceptar presupuesto',
  'global:estimate_rejected' => 'Presupuesto rechazado',
  'global:estimate_accepted' => 'Presupuesto aceptado',
  'global:reject_proposal' => 'Rechazar propuesta',
  'global:accept_proposal' => 'Aceptar propuesta',
  'global:proposal_rejected' => 'Propuesta rechazada',
  'global:proposal_accepted' => 'Propuesta aceptada',
  'global:client_area' => 'Área de clientes',
  'global:admin' => 'Admin',
  'global:all_settings' => 'Todos los ajustes',
  'global:viewable' => 'Visible en el área del cliente',
  'global:not_viewable' => 'No visible en el área del cliente',
  'global:milestones' => 'Hitos',
  'dashboard:collected' => 'Recolectado',
  'dashboard:outstanding' => 'Pendiente',
  'dashboard:latest_activity' => 'Actividad reciente',
  'dashboard:these_are_your_upcoming_tasks' => 'Estas son sus próximas tareas, :1.',
  'dashboard:upcoming_tasks' => 'Próximas tareas',
  'login:forgotinstructions' => 'Introduzca su dirección de correo electrónico para que podamos enviarle un correo electrónico para restablecer su contraseña.',
  'login:reset' => 'Resetear Password',
  'login:username' => 'Usuario',
  'login:password' => 'Password',
  'login:changepassword' => 'Cambiar Password',
  'login:email' => 'Email',
  'login:login' => 'Login',
  'login:logout' => 'Salir',
  'login:remember' => 'Recordarme',
  'login:forgot' => '¿Olvidaste tu contraseña?',
  'login:cancel' => '&laquo; Cancelar',
  'groups:edit_title' => 'Editar Grupo %s',
  'groups:add_title' => 'Añadir grupo de usuarios',
  'clients:title' => 'Todos los clientes',
  'clients:filter' => 'Filtrar Cliente',
  'clients:add' => 'Agregar Cliente',
  'clients:removefilter' => 'Borrar Filtro',
  'clients:edit' => 'Editar Cliente',
  'clients:noclienttitle' => 'Es necesario introducir algunos clientes!',
  'clients:noclientbody' => 'Así que usted puede enviar algunas facturas. Añadir uno ahora?',
  'clients:noclienttitlefilter' => 'No hay clientes que coincidan con tu filtro',
  'clients:hasnoinvoicetitle' => 'Genial! el cliente está agregado',
  'clients:hasnoinvoicebody' => 'Crear una factura para ellos y obtener pagos! Añadir una ahora?',
  'clients:added' => 'El cliente ha sido agregado!',
  'clients:edited' => 'El cliente ha sido actualizado!',
  'clients:deleted' => 'El cliente ha sido eliminado!',
  'clients:does_not_exist' => 'Ese cliente no existe!',
  'clients:health_check' => 'Chequeo de salud',
  'clients:all' => 'Todo',
  'clients:delete_title' => 'Borrar este cliente?!?!',
  'clients:delete_message' => '¿Seguro que quieres borrar este cliente? <br /> Esto también eliminará todas sus facturas, proyectos y propuestas.',
  'clients:clientaction' => '&nbsp;',
  'clients:passphrase' => 'Frase de contraseña',
  'clients:bad_passphrase' => 'Frase de contraseña es incorrecta.',
  'clients:total_clients' => 'Clientes totales',
  'clients:support' => 'Soporte',
  'clients:support_rates' => 'Valor de soporte',
  'clients:edit_support_rates' => 'Establecer tarifas',
  'contact:title' => 'Historial de contacto reciente',
  'contact:method' => 'Método de contacto',
  'contact:contact' => 'Contacto',
  'contact:subject' => 'Sujeto',
  'contact:content' => 'Contenido',
  'contact:calling_title' => 'Llamando cliente ":1"',
  'invoices:markassent' => 'Marcar como enviado',
  'invoices:invoicedate' => 'Fecha de la factura',
  'invoices:file_name' => 'Nombre de archivo',
  'invoices:date_created' => 'Fecha de creación',
  'invoices:size' => 'Tamaño',
  'invoices:files' => 'Archivos',
  'invoices:sentbutunpaid' => 'Facturas envíadas al cliente pero aún impagas',
  'invoices:duplicated' => 'Duplicado de la factura #:1. El número de la nueva factura es el #:2.',
  'invoices:all' => 'Todas las facturas',
  'invoices:empty' => 'No hay facturas aún.',
  'invoices:overdue' => 'Facturas vencidas',
  'invoices:tax_collected' => 'Impuestos recolectados',
  'invoices:paid' => 'Facturas pagadas',
  'invoices:recurringinvoices' => 'Facturas recurrentes',
  'invoices:unsentinvoices' => 'Facturas sin enviar',
  'invoices:unpaid' => 'Facturas impagas',
  'invoices:thisinvoicewaspaidon' => 'Esta factura se pagó el :1. Gracias!',
  'invoices:senton' => 'Enviado el :1',
  'invoices:lastsenton' => 'Última enviada el :1 a las :2',
  'invoices:paidon' => 'Pagada el :1',
  'invoices:paidonsingle' => 'Pagada el',
  'invoices:thisinvoiceisunpaid' => 'Esta factura no ha sido pagada aún.',
  'invoices:noinvoicetitle' => 'No hay facturas pendientes!',
  'invoices:noinvoicesforthefilteredclient' => 'No tienes facturas para :1.',
  'invoices:noinvoicebody' => 'Deberías crear una factura ahora! <br /> Los clientes aman las facturas!',
  'invoices:send_now_title' => 'Enviar factura ahora?',
  'invoices:send_now_body' => 'Rellene el siguiente formulario y enviaremos la factura para usted.',
  'invoices:newinvoice' => 'Crear factura',
  'invoices:send_now' => 'Enviar factura',
  'invoices:timequantity' => 'Tiempo/Cantidad',
  'invoices:ratewithcurrency' => 'Tarifa (:1)',
  'invoices:taxable' => 'Imponible',
  'invoices:total' => 'Total',
  'invoices:amount' => 'Monto',
  'invoices:due' => 'Vence',
  'invoices:subtotal' => 'Subtotal',
  'invoices:totaltax' => 'Impuesto total',
  'invoices:filestodownload' => 'Archivos para descargar',
  'invoices:added' => 'La factura ha sido añadida!',
  'invoices:fileswillbeavailableafterpay' => 'Estos archivos estarán disponibles para su descarga una vez que la factura haya sido pagado en su totalidad.',
  'invoices:no_payment_gateways_enabled' => 'No hay pasarelas de pago, lo que podría hacer que sea difícil de pagar. Habilitar en <a href=":1"> Ajustes </a>',
  'invoices:invoicenumber' => 'Factura #:1',
  'invoices:number' => 'Factura #',
  'invoices:type' => 'Tipo de factura',
  'invoices:is_recurring' => 'Recurrente?',
  'invoices:is_paid' => 'Pagado?',
  'invoices:is_sent' => 'Enviado?',
  'invoices:date_entered' => 'Fecha de creación',
  'invoices:delete_title' => 'Borrar esta factura?',
  'items:select_time_entry' => 'Entrada temporal',
  'invoices:delete_message' => 'Estás seguro que quieres eliminar esta factura?',
  'invoices:create' => 'Crear factura',
  'invoices:edit' => 'Editar factura',
  'invoices:amountrequired' => 'Se requiere que el campo Cantidad',
  'invoices:currencydoesnotexist' => 'Esta moneda no existe.',
  'invoices:unique_id' => 'ID único',
  'invoices:willreoccurin' => 'Esta factura re ocurrirá el :1.',
  'invoices:willbesentautomatically' => 'El cliente será notificado por correo electrónico acerca de esta factura el :1.',
  'invoices:thisisareoccurrence' => 'Esta factura es una repetición de la factura :1.',
  'invoices:clientlastnotifiedon' => 'El cliente fue notificado por correo electrónico acerca de esta factura el :1.',
  'invoices:simple' => 'Simple',
  'invoices:simple_help' => 'Una factura sencilla no tiene elementos de línea. Simplemente un total.',
  'invoices:detailed' => 'Detallada',
  'invoices:detailed_help' => 'Facturas detalladas permitirá tener varios elementos de línea.',
  'invoices:estimate_help' => 'Los presupuestos son facturas detalladas que no son facturables.',
  'invoices:unpaid_totalamount' => 'Sin pagar / Monto total',
  'invoices:saveinvoice' => 'Guardar factura',
  'invoices:deleted' => 'La factura ha sido eliminada!',
  'invoices:view' => 'Ver factura',
  'invoices:is_viewable' => 'Mostrar en el área del cliente?',
  'invoices:no_invoices' => 'No hay facturas.',
  'invoices:addedsuccess' => 'Has agregado una factura por',
  'invoices:invoice' => 'factura',
  'invoices:addedconf' => 'Has agregado una factura # <strong>:1</strong>, totalizando <strong>:2</strong> (:3 con impuestos) por :4:5.',
  'invoices:preview' => 'Previsualizar factura',
  'invoices:editinvoice' => 'Editar factura #:1',
  'invoices:messageupdated' => 'La factura ha sido actualizada!',
  'invoices:resend' => 'Reenviar factura',
  'invoices:client_viewed' => ':1 vio <a href=":2">factura #:3</a> el :4',
  'invoices:client_paid' => ':1 pagó <a href=":2">factura #:3</a> el :4',
  'invoice:paid_amount' => 'Monto pagado',
  'estimates:attachedtoproposal' => 'Se adjunta a la propuesta #:1',
  'estimates:duplicated' => 'Duplicado presupuesto #:1. El número del nuevo presupuesto es #:2.',
  'estimates:alltitle' => 'Todos los presupuestos',
  'estimates:attachingtoproposal' => 'Agregando presupuesto a la propuesta, por favor espere...',
  'estimates:delete_title' => 'Borrar este presupuesto?',
  'estimates:delete_message' => '¿Estás seguro que quieres eliminar este presupuesto?',
  'estimates:createnew' => 'Crear presupuesto',
  'estimates:generate_estimate' => 'Generar presupuesto',
  'estimates:converted' => 'Presupuesto #:1 convertido a proyecto.',
  'estimates:converted_to_invoice' => 'Presupuesto #:1 convertido a factura.',
  'estimates:noestimatetitle' => 'No tienes presupuestos',
  'estimates:noestimatesforthisclient' => 'No tienes presupuestos para este cliente.',
  'estimates:noestimatesforthefilteredclient' => 'No tienes presupuestos para :1.',
  'estimates:deleted' => 'El presupuesto ha sido eliminado!',
  'estimates:noestimatebody' => '¿Crear uno ahora?',
  'estimates:estimatenumber' => 'Presupuesto #:1',
  'estimates:view' => 'Ver presupuesto',
  'estimates:no_estimates' => 'No hay presupuestos.',
  'estimates:addedsuccess' => 'Has agregado un presupuesto para',
  'estimates:estimate' => 'presupuesto',
  'estimates:added' => 'El presupuesto se ha añadido exitosamente',
  'estimates:addedconf' => 'Ha agregado presupuesto # <strong> :1 </ strong>, por un total de <strong>:2</strong> (:3 con impuestos) para :4:5.',
  'estimates:send_now_title' => 'Enviar presupuesto ahora?',
  'estimates:send_now_body' => 'Rellena el siguiente formulario y enviaremos el presupuesto.',
  'estimates:send_now' => 'Enviar presupuesto',
  'estimates:edit' => 'Editar presupuesto',
  'estimates:preview' => 'Previsualizar presupuesto',
  'estimates:editestimate' => 'Editar presupuesto #:1',
  'estimates:messageupdated' => 'El presupuesto ha sido actualizado!',
  'estimates:client_viewed' => ':1 ver <a href=":2">presupuesto #:3</a> el :4',
  'estimates:client_accepted' => ':1 aceptado <a href=":2">presupuesto #:3</a> el :4',
  'estimates:client_rejected' => ':1 rechazado <a href=":2">presupuesto #:3</a> el :4',
  'estimates:resend' => 'Reenviar presupuesto',
  'estimates:estimatedate' => 'Fecha estimada',
  'projects:status_id' => 'Estado de la tarea',
  'projects:projected' => 'Proyectado',
  'projects:projected_hours' => 'Horas proyectadas',
  'projects:navigationitem' => 'Proyectos',
  'projects:hours_worked' => 'Número de horas trabajadas',
  'projects:hours_worked_short' => 'Horas trabajadas',
  'projects:alltitle' => 'Todos los proyectos',
  'projects:totalprojects' => 'Total Proyectos',
  'projects:noprojecttitle' => 'No hay proyectos todavía!',
  'projects:noprojecttext' => '¿Quieres crear uno ahora? ',
  'projects:add' => 'Crear proyecto',
  'projects:createfromtemplate' => 'Crear proyecto desde plantilla',
  'projects:doesnotexist' => 'El proyecto que estás tratando de acceder no existe.',
  'projects:edit' => 'Editar proyecto',
  'projects:delete' => 'Borrar proyecto',
  'projects:project' => 'Proyecto',
  'projects:new_project_from_estimate_without_number' => 'Nuevo proyecto desde presupuesto',
  'projects:new_project_from_estimate_with_number' => 'Nuevo proyecto desde presupuesto nro #:1',
  'projects:due_date' => 'Fecha de entrega',
  'projects:is_completed' => 'Completado?',
  'projects:manage_project' => 'Gestionar proyecto',
  'projects:areyousuredeletetask' => '¿Seguro que quieres eliminar esta tarea?',
  'projects:add_time' => 'Agregar entrada temporal',
  'projects:add_hours' => 'Agregar horas',
  'projects:generate_invoice' => 'Generar factura',
  'projects:no_projects' => 'No hay proyectos.',
  'projects:archive_proj' => 'Archivar proyecto',
  'projects:unarchive_proj' => 'Desarchivar proyecto',
  'projects:archive' => 'Ver archivo',
  'projects:active' => 'Proyectos activos',
  'projects:archived' => 'Proyectos archivados',
  'projects:noarchivedprojecttitle' => 'No hay proyectos archivados.',
  'projects:noarchivedprojecttext' => 'Puede archivar un proyecto desde la página del proyecto',
  'projects:allarchivedtitle' => 'Todos los proyectos archivados',
  'projects:templatize' => 'Guardar como plantilla',
  'projects:milestone_identifier' => '[Hito: :1]',
  'milestones:add' => 'Agregar Hito',
  'milestones:edit' => 'Editar Hito',
  'milestones:delete' => 'Borrar Hito',
  'milestones:milestone' => 'Hito',
  'milestones:target_date' => 'Fecha Estimada',
  'milestones:assigned_user' => 'Usuario asignado',
  'milestones:select_default' => '-- No hay hitos --',
  'milestones:no_milestone' => 'Tareas sin hito',
  'milestones:add_success' => 'Hito ":1" agregado exitosamente!',
  'milestones:edit_success' => 'Hito ":1" editado exitosamente!',
  'milestones:add_failed' => 'Hito ":1" no pudo ser editado.',
  'milestones:edit_failed' => 'Hito ":1" no pudo ser agregado.',
  'milestones:are_you_sure_delete' => '¿Seguro que quieres borrar este hito?',
  'milestones:delete_success' => 'Hito ":1" eliminado exitosamente!',
  'milestones:does_not_exist' => 'Este hito no existe.',
  'milestones:select_assignee_default' => 'Sin asignado',
  'proposal:outline' => 'Bosquejo de propuesta',
  'reminders:reminders' => 'Recordatorios',
  'reminders:send' => 'Enviar Recordatorios',
  'reminders:success' => 'Estos recordatorios han sido enviados!!',
  'reminders:remind' => 'Recordar',
  'reminders:message' => 'Mensaje',
  'reminders:due' => 'Días',
  'reminders:details' => 'Detalles',
  'reminders:log' => 'Registro',
  'emailtemplates:email_templates' => 'Plantillas de mail',
  'emailtemplates:create_template' => 'Crear plantilla',
  'emailtemplates:add' => 'Crear nueva plantilla de mail',
  'emailtemplates:edit' => 'Editar plantilla de mail',
  'emailtemplates:manage' => 'Gestionar plantillas',
  'emailtemplates:name' => 'Nombre del Email',
  'emailtemplates:subject' => 'Asunto del correo',
  'emailtemplates:days' => 'Rango de días',
  'emailtemplates:type' => 'Tipo de plantilla',
  'emailtemplates:success' => 'Plantilla de correo electrónico creada con éxito',
  'emailtemplates:edited' => 'Plantilla de correo electrónico editada con éxito',
  'emailtemplates:does_not_exist' => 'Plantilla de email no existe',
  'emailtemplates:deleted' => 'Plantilla de correo electrónico eliminada correctamente',
  'emailtemplates:delete_title' => 'Eliminar plantilla de correo electrónico',
  'emailtemplates:delete_message' => '¿Seguro que deseas eliminar esta plantilla de correo electrónico?',
  'reports:perclient' => 'por cliente',
  'reports:datefrom' => 'Desde',
  'reports:allclients' => 'Todos los clientes',
  'reports:dateto' => 'Para',
  'reports:byclient' => 'Cliente',
  'reports:view' => 'Ver reporte',
  'reports:show_all' => 'Mostrar reportes',
  'reports:paid_and_unpaid' => 'Pagados y sin pagar',
  'reports:paid_vs_unpaid_over_time' => 'Pagado vs. Sin pagar en el tiempo',
  'reports:per_client' => 'por cliente',
  'reports:total_with_tax' => 'Total (con impuesto)',
  'reports:total_without_tax' => 'Total (sin impuesto)',
  'reports:total_collected' => 'Total Recolectado',
  'reports:fees_paid' => 'Honorarios pagados',
  'reports:total_amount' => 'Monto total',
  'reports:paid_amount' => 'Monto pagado',
  'reports:unpaid_amount' => 'Monto sin pagar',
  'reports:client_name' => 'Nombre del cliente',
  'reports:nodata' => 'Sin :1.',
  'currencies:default' => '[Por defecto] :1',
  'currencies:cad' => 'Dolar canadiense',
  'currencies:eur' => 'Euro',
  'currencies:usd' => 'U.S. Dollar',
  'currencies:gbp' => 'Libra esterlina',
  'currencies:hkd' => 'Dolar de Hong Kong',
  'currencies:php' => 'Peso Philippine',
  'currencies:zar' => 'Rand de Sud Africa',
  'proposals:duplicated' => 'Propuesta duplicada #:1. El número de la nueva propuesta es #:2.',
  'proposals:usesectiontemplate' => 'Usar esta plantilla de sección',
  'proposals:showcontents' => 'Mostrar contenidos',
  'proposals:hidecontents' => 'Esconder contenidos',
  'proposals:deletepremadesection' => 'Borrar plantilla de sección',
  'proposals:nopremadesections' => 'No tienes plantillas de sección guardadas.',
  'proposals:newproposal' => 'Nueva propuesta',
  'proposals:number' => 'Propuesta #',
  'proposals:all' => 'Todas las propuestas',
  'proposals:noproposaltitle' => 'No hay propuestas!',
  'proposals:noproposalbody' => 'Tu deberías crear una propuesta ahora, definitivamente!.',
  'proposals:client_viewed' => ':1 vista <a href=":2">propuesta #:3</a> el :4',
  'proposals:client_accepted' => ':1 aceptada <a href=":2">propuesta #:3</a> el :4',
  'proposals:client_rejected' => ':1 rechazada <a href=":2">propuesta #:3</a> el :4',
  'proposals:rejected' => 'Rechazada el :1',
  'proposals:accepted' => 'Aceptada el :1',
  'proposals:lastviewed' => 'Última vez revisada por el cliente el :1, a las :2.',
  'proposals:neverviewed' => 'no ha sido revisada por el cliente.',
  'proposals:noanswer' => 'Sin respuesta',
  'proposals:createproposal' => 'Crear propuesta',
  'proposals:editproposal' => 'Editar propuesta',
  'proposals:createdsuccessfully' => 'Propuesta creada!',
  'proposals:sections' => 'Secciones',
  'proposals:section' => 'Sección',
  'proposals:createsection' => 'Agregar nueva sección',
  'proposals:createpage' => 'Agregar página',
  'proposals:emptysection' => '(Sin título)',
  'proposals:emptycontents' => '(Sin contenidos)',
  'proposals:emptysubtitle' => '(Sin subtítulo)',
  'proposals:for' => 'Propuesta para:',
  'proposals:pagexofcount' => 'Página :1 de :2',
  'proposals:saving' => 'Guardando...',
  'proposals:save' => 'Guardar propuesta',
  'proposals:savepremade' => 'Guardar plantilla de sección',
  'proposals:addestimate' => 'Agregar presupuesto',
  'proposals:saved' => 'Guardado!',
  'proposals:createandedit' => 'Siguiente: Editar contenido de la propuesta',
  'proposals:delete_message' => 'Estás seguro que quieres eliminar esta propuesta??',
  'proposals:createpremadesection' => 'Agregar desde plantilla de sección',
  'proposals:selected_attachments' => 'Seleccionar presupuesto',
  'proposals:attach_selected_estimate' => 'Adjuntar el presupuesto seleccionado',
  'proposals:proposal' => 'Propuesta',
  'proposals:status' => 'Estado',
  'proposals:view' => 'Ver propuesta',
  'proposals:estimate' => 'Presupuesto',
  'proposals:no_proposals' => 'No hay propuestas.',
  'proposals:proposal_title' => 'Título de la propuesta',
  'proposals:kitchennotice' => 'Nota: Propuestas aparecerán en :1 una vez que el cliente haya revisado el enlace de la propuesta. Eso significa que tu puedes editarla todas las veces que quieras, el cliente no lo verá hasta que tu quieras.',
  'tasks:task' => 'Tareas',
  'tasks:edit_succeeded' => 'Editada la tarea con éxito.',
  'tasks:hours' => 'Horas',
  'tasks:due_date' => 'Fecha de vencimiento',
  'tasks:is_completed' => 'Completado?',
  'tasks:timer' => 'Timer',
  'tasks:rate' => 'Tarifa',
  'tasks:default_rate' => 'Tarifa por defecto',
  'tasks:entries' => 'Entradas de tiempo',
  'tasks:view_entries' => 'Ver entradas',
  'tasks:edit_entry' => 'Editar entrada',
  'tasks:create' => 'Agregar tarea',
  'tasks:create_sub' => 'Agregar sub-tarea',
  'tasks:task_parent' => 'Tarea Padre',
  'tasks:edit' => 'Editar tarea',
  'tasks:create_succeeded' => 'La tarea ha sido creada!',
  'tasks:no_task_title' => 'Hmm, no hay tareas aún...',
  'tasks:no_task' => 'No hay tareas',
  'tasks:no_task_message' => 'Debes crear tareas!',
  'tasks:is_viewable' => 'Visible en el área del cliente?',
  'tasks:no_milestones' => 'Tareas sin hitos asociados',
  'tasks:not_related_to_a_task' => '-- No relacionado a una tarea --',
  'tasks:select_parent_default' => '-- Sin tarea padre --',
  'tasks:timers_running' => 'Relojes corriendo',
  'tasks:task_completed_by' => ':1 Completada <a href=":2">tarea :3</a> a las :4',
  'tasks:discussion' => 'Discusión: ',
  'tasks:billed_hours' => 'Horas facturadas',
  'tasks:unbilled_hours' => 'Horas sin facturar',
  'users:create_user' => 'Crear usuario',
  'users:confirm_delete_emphasised' => 'No hay vuelta atrás!',
  'items:name' => 'Nombre del ítem',
  'items:description' => 'Descripción del ítem',
  'items:qty_hrs' => 'Cant / Hrs',
  'items:quantity' => 'Cantidad',
  'items:rate' => 'Tarifa',
  'items:tax_rate' => 'Impuesto',
  'items:cost' => 'Costo',
  'items:line_items' => 'Elementos de línea',
  'items:add' => 'Agregar Ítem',
  'items:edit' => 'Editar Ítem',
  'items:noitemtitle' => 'No tienes ítems aún!',
  'items:noitembody' => 'Deberías agregar ítems ahora, facilita la creación de facturas',
  'items:delete_title' => 'Borrar este ítem?',
  'items:delete_message' => 'Estás seguro que quieres borrar este ítem ":1"?',
  'items:type' => 'Tipo',
  'items:select_standard' => 'Estándar',
  'items:select_expense' => 'Gasto',
  'items:add_expense_to_project' => 'Agregar gasto',
  'items:expenses' => 'Gastos',
  'expenses:expenses' => 'Gastos',
  'expenses:add' => 'Agregar gasto',
  'expenses:edit_expense' => 'Editar gasto',
  'expenses:delete' => 'Borrar gasto',
  'expenses:deleted' => 'Gasto eliminado',
  'expenses:all' => 'Todos los gastos',
  'expenses:amount' => 'Monto',
  'expenses:supplier' => 'Proveedor',
  'expenses:suppliers' => 'Proveedores',
  'expenses:category' => 'Categoría',
  'expenses:categories' => 'Categorías',
  'expenses:add_supplier' => 'Añadir Proveedor',
  'expenses:edit_supplier' => 'Editar Proveedor',
  'expenses:add_category' => 'Añadir categoría',
  'expenses:edit_category' => 'Editar categorías',
  'expenses:parent_category' => 'Categoría superior',
  'expenses:filter' => 'Filtrar gastos',
  'expenses:start_date' => 'Fecha de inicio',
  'expenses:end_date' => 'Fecha de término',
  'transactions:paymentcancelled' => 'Pago cancelado',
  'transactions:extrapaymentcancelled' => 'El pago ha sido cancelado.',
  'transactions:paymentreceived' => 'Pago recibido!',
  'transactions:fee_applied' => 'Como :1 impone una cuota por transacción, hemos agregado un recargo de :2%.',
  'transactions:orderbeingprocessed' => 'Por favor espere, su pedido se está procesando y usted será redirigido a la :1 Página.',
  'transactions:ifyouarenotredirected' => 'Si no se te redirige automáticamente a :1 en 5 segundos ...',
  'transactions:thankyouforyourpayment' => 'Gracias por su pago. Recibirás un recibo por correo electrónico en breve.',
  'transactions:ifyouhavefilesyouwillgetanemail' => 'Si tiene archivos en espera, recibirás un correo electrónico con un enlace para descargar en breve.',
  'transactions:ifyoudonotreceiveemail' => 'Si no recibes un correo electrónico dentro de una hora por favor póngase en contacto con :1',
  'timesheet:taskname' => 'Nombre de la tarea',
  'timesheet:starttime' => 'Hora de inicio',
  'timesheet:endtime' => 'Hora de término',
  'timesheet:timeframe' => 'Período de tiempo',
  'timesheet:duration' => 'Duración',
  'timesheet:date' => 'Fecha',
  'timesheet:forproject' => 'Horas para el proyecto ":1"',
  'timesheet:timesheet' => 'Horas',
  'timesheet:for' => 'Horas para:',
  'timesheet:totalbillable' => 'Total de horas facturables',
  'timesheet:view_pdf' => 'Ver horas',
  'timesheet:user' => 'Usuario',
  'timesheet:entries' => 'Entradas',
  'timesheet:no_entries' => 'No hay entradas de tiempo.',
  'tickets:all_tickets' => 'Tickets de soporte',
  'tickets:support_tickets' => 'Tickets de soporte',
  'tickets:pending' => 'Pendientes',
  'tickets:open' => 'Abiertos',
  'tickets:resolved' => 'Resueltos',
  'tickets:closed' => 'Cerrados',
  'tickets:respond' => 'Responder ticket',
  'tickets:ticket_options' => 'Opciones de ticket',
  'tickets:attachment' => 'Adjuntos',
  'tickets:updated_status' => 'El estado del ticket :1 ha sido actualizado a :2',
  'tickets:add_a_new_ticket' => 'Agregar nuevo ticket',
  'tickets:create_a_new_ticket' => 'Crear nuevo ticket',
  'tickets:add_ticket' => 'Agregar ticket',
  'tickets:assign_to_user' => 'Asignar a usuario',
  'tickets:select_client' => 'Seleccionar cliente',
  'tickets:ticket_subject' => 'Asunto del ticket',
  'tickets:ticket_message' => 'Mensaje del ticket',
  'tickets:ticket_priority' => 'Prioridad del ticket',
  'tickets:ticket_status' => 'Estado del ticket',
  'tickets:no_priority' => '-- Sin prioridad --',
  'tickets:no_status' => '-- Sin estado --',
  'tickets:no_posts' => 'Sin mensaje.',
  'frontend:hithere' => 'Hola!',
  'frontend:followthemaillinkdude' => 'Para ver tu factura debes hacer click en el enlace completo enviado en el correo electrónico. Por ejemplo, :1.',
  'frontend:contactadminforassistance' => 'Por favor haz eso o contacta a :1 al :2 para ayuda',
  'settings:task_statuses' => 'Estados de tareas',
  'settings:ticket_statuses' => 'Estados de tickets',
  'settings:ticket_priorities' => 'Prioridades de tickets',
  'settings:background_color' => 'Color de fondo',
  'settings:text_color' => 'Color de texto',
  'settings:text_shadow' => 'Sombra de texto',
  'settings:box_shadow' => 'Sombra de caja',
  'settings:default_rate' => 'Valor por defecto',
  'settings:allowed_extensions' => 'Extensiones de subida permitidas',
  'settings:comma_separated' => 'separadas por comas',
  'settings:pdf_page_size' => 'Tamaño de página PDF',
  'settings:default_invoice_notes' => 'Notas de factura por defecto',
  'settings:default_invoice_title' => 'Título de factura por defecto',
  'settings:default_invoice_due_date' => 'Fecha de vencimiento de factura por defecto',
  'settings:autosave_proposals' => 'Auto guardado de propuestas',
  'settings:default_invoice_due_date_explain' => 'días después de que la factura ha sido creada. Si no quieres una fecha por defecto, dejar esto en blanco.',
  'settings:testemailsettings' => 'Ajustes para el mail de pruebas',
  'settings:include_remittance_slip' => 'Ticket de remesa',
  'settings:include_remittance_slip_explain' => 'Si está marcado, los PDFs de las facturas incluirán gastos.',
  'settings:items_per_page' => 'Ítems por página',
  'settings:items_per_page_explain' => 'Número de ítems (facturas/presupuestos/propuestas/proyectos/tareas) a mostrar por página.',
  'settings:send_x_days_before' => '"enviar X días antes" por defecto',
  'settings:send_x_days_before_explain' => 'Número predeterminado de días antes de una factura sea auto-enviada a un cliente.',
  'settings:file_to_import' => 'Archivo a importar',
  'settings:file_should_be_csv' => 'Pancake procesará automáticamente su archivo e importará todo lo que contiene. Si Pancake es incapaz de procesar su archivo, éste se lo hará saber, y se le dará la opción de enviarnos alguna información para ayudarte a importar el archivo.',
  'settings:importnow' => 'Importar ahora!',
  'settings:whatimporting' => 'Qué estás importando?',
  'settings:whatexporting' => 'Qué estás exportando?',
  'settings:nouploadedimportfile' => 'No subiste un archivo para importar.',
  'settings:import' => 'Importar',
  'settings:importedclients' => 'Importados :1 clientes exitosamente.',
  'settings:importedprojects' => 'Importados :1 proyectos exitosamente.',
  'settings:importedusers' => 'Importados :1 usuarios exitosamente.',
  'settings:importedinvoices' => 'Importados :1 facturas exitosamente.',
  'settings:importedtasks' => 'Importados :1 tareas exitosamente.',
  'settings:importedestimates' => 'Importados :1 presupuestos exitosamente.',
  'settings:importedtime_entries' => 'Importadas :1 entradas temporales exitosamente.',
  'settings:xwereduplicates' => ':1 eran duplicadas y se ignoraron.',
  'settings:import_desc' => 'Importar información a Pancake.',
  'settings:export' => 'Exportar',
  'settings:exportnow' => 'Exportar ahora!',
  'settings:importexport' => 'Importar / Exportar',
  'settings:removelogo' => 'Borrar Logo',
  'settings:wrong_license_key' => 'La llave de licencia que ha introducido no es válida.',
  'settings:noopenssl' => 'Tu servidor de PHP no tiene configurado OpenSSL, lo que significa que no puedes utilizar Gmail o Google Apps para enviar emails. Ponte en contacto con tu hosting y hazles saber que requieres OpenSSL.',
  'settings:logoremoved' => 'Logo eliminado exitosamente!',
  'settings:save' => 'Guardar configuraciones',
  'settings:logodimensions' => 'El logo puede ser subido en cualquier tamaño y será redimensionado automáticamente.',
  'settings:logoformatsallowed' => 'BMP, PNG, JPG (JPEG) y GIF son permitidos.',
  'settings:ftp_user' => 'Usuario FTP',
  'settings:ftp_pass' => 'Contraseña FTP ',
  'settings:ftp_path' => 'Camino FTP',
  'settings:ftp_port' => 'Puerto FTP',
  'settings:ftp_pasv' => 'Modo pasivo?',
  'settings:nophpupdates' => 'Debido a la forma en que tu servidor está configurado, tendrás que introducir los datos del FTP para que Pancake pueda actualizarse. Estos datos son utilizados internamente por Pancake y nunca se transmiten a nadie.',
  'settings:ftp_host' => 'Servidor de FTP',
  'settings:uptodate' => 'Pancake está actualizado (:1)',
  'settings:newversionavailable' => 'Existe una nueva versión de Pancake Disponible (:1)!',
  'settings:updatenow' => 'Actualizar ahora!',
  'settings:checkforupdates' => 'Check for updates',
  'settings:youneedtoconfigurefirst' => 'Su Pancake aún no está configurado para actualizarse. Por favor, introduzce tus datos de FTP a continuación, pulsa "Guardar configuración". <br /> Pancake se actualizará automáticamente.',
  'settings:general' => 'General',
  'settings:emails' => 'Emails',
  'settings:taxes' => 'Impuestos',
  'settings:currencies' => 'Monedas',
  'settings:branding' => 'Marca',
  'settings:payment_methods' => 'Pagos',
  'settings:feeds' => 'Fuentes',
  'settings:api_keys' => 'Llaves API',
  'settings:time_entry_times' => 'Entrada de tiempo',
  'settings:include_dates_and_times_in_line_items' => 'Incluir fechas y horas en las descripciones de artículos de línea "entrada de tiempo".',
  'settings:when_generating_invoice' => 'Cuando se generen facturas, usar una línea por ítem',
  'settings:use_utf8_font' => 'Utilizar una tipografía UTF-8 en PDFs',
  'settings:use_utf8_font_explanation' => 'Utilice esta opción si las tipografías se estropean en sus archivos PDF.',
  'settings:pdf_attachments' => 'PDF Adjuntos',
  'settings:pdf_attachments_explanation' => 'Si está marcado, Pancake adjuntará el PDF correspondiente a la factura, presupuesto o propuesta a los correos electrónicos.',
  'settings:site_name' => 'Nombre del sitio',
  'settings:language' => 'Lenguaje',
  'settings:timezone' => 'Huso horario',
  'settings:notify_email' => 'mail de notificación',
  'settings:currency' => 'Moneda',
  'settings:theme' => 'Tema de front',
  'settings:admin_theme' => 'Tema de admin',
  'settings:admin_name' => 'Nombre de admin',
  'settings:date_format' => 'Formato de fecha',
  'settings:time_format' => 'Formato de hora',
  'settings:task_time_interval' => 'Redondeo de entrada temporal (Dejar en blanco para no redondear)',
  'settings:task_time_interval_description' => '(ej 00:30 o 0,5 - todas las entradas de tiempo se redondean a la más cercana doce y media cuando se factura por ellos en una factura.)',
  'settings:mailing_address' => 'Dirección de correos',
  'settings:default_subject' => 'Asunto predeterminado',
  'settings:default_contents' => 'Mensaje del asunto',
  'settings:new_estimate' => 'Nueva estimación',
  'settings:new_invoice' => 'Nueva factura',
  'settings:new_proposal' => 'Nuevo presupuesto',
  'settings:paid_notification' => 'Notificación de pago',
  'settings:payment_receipt' => 'Recibo de pago',
  'settings:new_ticket' => 'Nuevo ticket',
  'settings:ticket_invoice' => 'Nuevo ticket de factura',
  'settings:ticket_updated' => 'Ticket actualizado',
  'settings:ticket_status_updated' => 'Estado del ticket actualizado',
  'settings:logo' => 'Tu logo',
  'settings:frontend_css' => 'CSS personalizado para Frontend',
  'settings:backend_css' => 'CSS personalizado para Backend ',
  'settings:rss_password' => 'Password del RSS',
  'settings:default_feeds' => 'Fuentes por defecto',
  'settings:cron_job_feed' => 'Trabajo de servidor configurado por horario',
  'settings:feed_generator' => 'Generador de fuentes',
  'settings:your_link' => 'Tu enlace',
  'settings:bcc' => 'CCO',
  'settings:automaticallybccclientemail' => 'Automáticamente enviar una copia al cliente de todos los emails al mail de notificación (definido más adelante)',
  'settings:api_note' => 'Nombre / Nota',
  'settings:api_key' => 'Llave',
  'settings:tax_name' => 'Nombre del impuesto',
  'settings:tax_value' => 'Valor',
  'settings:tax_reg' => 'Registro / código',
  'settings:add_tax' => 'Agregar otro impuesto',
  'settings:currency_name' => 'Nombre de la moneda',
  'settings:currency_code' => 'Código de la moneda',
  'settings:exchange_rate' => 'Tipo de cambio',
  'settings:add_currency' => 'Agregar otra moneda',
  'update:ifyourenotsurecontactus' => 'Si no estás seguro de qué hacer, <a href=\'http://pancakeapp.com/forums/newtopic/2/\'> empezar un nuevo tema de soporte técnico en los foros </a>.',
  'update:youmodified' => 'Tú modificaste',
  'update:youdeleted' => 'Tú eliminaste',
  'update:loadingpleasewait' => 'Cargando, por favor espere...',
  'update:errordownloading' => 'Una actualización de Pancake está disponible, pero existen problemas para descargarla.',
  'update:herearestepstofix' => 'Aquí una lista de algunos pasos que puedes tratar para solucionarlos:',
  'update:makesureuploadsiswritable' => 'Asegurate de que la carpeta de uploads tenga permisos de escritura (CHMOD 0777).',
  'update:deletepancakesystemupdate' => 'Eliminar la carpeta pancake-update-system dentro de la carpeta de uploads, y todos sus contenidos.',
  'update:loadpancakeagain' => 'Cargar Pancake nuevamente. Si el error persiste, cambiar el propietario de la carpeta Pancake (chown) para que coincida con el usuario del servidor web. Si usted no puede hacer eso, o no saben cómo, por favor envíanos un correo electrónico a support@pancakeapp.com, y te ayudaremos.',
  'update:whatschanged' => 'Qué hay de nuevo en :1',
  'update:ftp_conn' => 'Pancake no puede conectar con el servidor FTP.',
  'update:ftp_login' => 'Pancake no puede logear via FTP (usuario/password erróneo?).',
  'update:ftp_chdir' => 'Pancake no puede configurar la ruta del FTP (la ruta probablemente no existe).',
  'update:ftp_no_uploads' => 'Pancake no puede obtener permisos para subir archivos via FTP.',
  'update:ftp_indexwrong' => 'La ruta FTP que ingresaste es incorrecta. Debería ser la ruta donde está instalado Pancake.',
  'update:ftp_indexnotfound' => 'La ruta FTP que ingresaste es incorrecta. Debería ser la ruta donde está instalado Pancake.',
  'update:update_conflict' => 'Ha modificado algunos archivos desde la última actualización. Con el fin de salvaguardar sus personalizaciones, aquí hay una lista de los archivos que se han modificado, que entran en conflicto con la última actualización.',
  'update:update_no_perms' => 'Pancake does not have enough permissions to update itself, nor does it have access to an FTP account from which it can update itself. Update cannot continue.',
  'update:review_files' => 'Please review these files and make backups of them before proceeding. When the upgrade is finished, you will have to re-integrate your modifications back into them. Please do not just replace the updated files with your outdated modified copies, as that may break Pancake.',
  'update:internetissues' => 'Pancake is unable to connect to the Internet.',
  'update:pancakeneedsinternet' => 'For Pancake to function correctly, your server must allow it to fetch some information from the Internet (port 80).',
  'update:maybefirewall' => 'It appears that your server is blocking Pancake from accessing the Internet. This could be a firewall issue in your server. Please contact your host for help. Ask them to allow PHP to access :1.',
  'update:nointernetaccess' => 'No Internet Access',
  'update:pancakeupdated' => 'Pancake was upgraded from :1 to :2',
  'partial:partialpayments' => 'Plan de pagos',
  'partial:totalamounttobepaid' => 'Total a ser pagado por el cliente',
  'partial:amountlefttobeadded' => 'Monto faltante a ser agregado al plan',
  'partial:amounttoobig' => 'Monto que debe ser removido del plan',
  'partial:noamountneeded' => 'El plan de pagos está completo.',
  'partial:amount' => 'Monto',
  'partial:add_payment' => 'Agregar pago',
  'partial:dueon' => 'Vence el',
  'partial:addanother' => 'Agregar otro pago',
  'partial:disabledforrecurring' => 'Facturación recurrente está limitada a un solo pago',
  'partial:paymentdetails' => 'Detalles de pago',
  'partial:wrongtotal' => 'La suma de todas las partes de su plan de pago no coincide con la cantidad total de la factura.',
  'partial:problemsaving' => 'Se produjo un problema al guardar el plan de pago. Por favor, inténtalo de nuevo.',
  'partial:wrongtotalbutsaved' => 'La suma de todas las partes del plan de pago no coincide con la cantidad total que se facturó. <br /> Se guardaron los cambios en la factura, pero que debe arreglar el plan de pago',
  'partial:problemsavingbutsaved' => 'Se produjo un problema al guardar el plan de pago. Por favor, inténtelo de nuevo. <br /> Se guardaron los cambios en la factura, pero no en el plan de pago.',
  'partial:savepaymentdetails' => 'Guardar los datos de pago',
  'partial:partpaidthanks' => 'Esta parte de la factura ha sido pagada, gracias.',
  'partial:proceedtopayment' => 'Proceder al pago',
  'partial:topaynowgoto' => 'Para pagar ahora, dirigirse a :1',
  'partial:pay_part_x_now' => 'Pagar parte #:1 de la factura ahora',
  'partial:dueondate' => 'vence el :1',
  'partial:paymentmethod' => 'Método de pago',
  'partial:paymentdate' => 'Fecha de pago',
  'partial:paymentstatus' => 'Estado de pago',
  'partial:transactionid' => 'ID de transacción',
  'partial:markaspaid' => 'Marcar como pagado',
  'partial:transactionfee' => 'Impuesto de transacción',
  'paypal:clickhere' => 'Click para proceder',
  'authorize:transaction_key' => 'Llave de transacción',
  'paypal:email' => 'Email de PayPal',
  'paypal:fee' => 'Fee (%) de Paypal',
  'paypalpro:paypalpro' => 'PayPal Payments Pro (BETA)',
  'paypalpro:viacreditcard' => 'Pagar con tarjeta de crédito',
  'cash:cash' => 'Dinero',
  'check:check' => 'Cheque',
  'moneyorder:moneyorder' => 'Orden de pago',
  'creditcard:creditcard' => 'Tarjeta de crédito',
  'banktransfer:banktransfer' => 'Transferencia bancaria',
  'gateways:errorupdating' => 'Hubo un error al actualizar la configuración del método de pago. Por favor, póngase en contacto con soporte.',
  'gateways:paymentmethods' => 'Metodos de pago',
  'gateways:selectpaymentmethod' => 'Seleccionr método de pago',
  'gateways:nogatewayused' => 'Ningún método utilizado: la parte no ha sido pagada',
  'gateways:completed' => 'Completado',
  'gateways:refunded' => 'Reintegrado',
  'gateways:unpaid' => 'Sin pagar',
  'gateways:paymentrejected' => 'Pago :1 rechazado',
  'gateways:pending' => 'Pendiente',
  'gateways:returntowebsite' => 'Retornar a :1',
  'gateways:cc_type' => 'Tipo de tarjeta de crédito',
  'gateways:cc_number' => 'Número de la tarjeta de crédito',
  'gateways:cc_exp' => 'Fecha de vencimiento',
  'gateways:cc_cardholder' => 'Nombre en la tarjeta',
  'gateways:cc_code' => 'Código de seguridad',
  'gateways:payment_details' => 'Detalles de pago',
  'gateways:api_signature' => 'Firma de API',
  'gateways:api_password' => 'Password de API ',
  'gateways:api_username' => 'Usuario de API',
  'kitchen:edit_comment' => 'Editar comentario',
  'kitchen:add_a_comment' => 'Agregar un comentario',
  'kitchen:kitchen_name' => 'Área de acceso de clientes',
  'kitchen:pleaselogin' => 'Por favor ingresa tu password para acceder a esta cuenta',
  'kitchen:nocomments' => 'No hay comentarios aún.',
  'kitchen:comment' => 'Comentario',
  'kitchen:comments' => 'Comentarios',
  'kitchen:comments_x' => 'Comentarios (:1)',
  'kitchen:file' => 'Archivo',
  'kitchen:submitcomment' => 'Agregar comentario',
  'kitchen:attachment' => 'Adjunto',
  'kitchen:saidon' => 'dicho el :1, a las :2',
  'kitchen:subjectinvoice' => 'Nuevo comentario para Factura #',
  'kitchen:subjectestimate' => 'Nuevo comentario para Presupuesto #',
  'kitchen:subjectproject' => 'Nuevo comentario para Proyecto:',
  'kitchen:subjecttask' => 'Nuevo comentario para Tarea:',
  'kitchen:subjectproposal' => 'Nuevo comentario para Propuesta:',
  'kitchen:backtodashboard' => 'Volver al panel de control',
  'kitchen:client_welcome' => 'Acceso de cliente para:',
  'kitchen:urltosend' => 'URL de Acceso a cliente ',
  'kitchen:nopassphrase' => 'Actualmente, el cliente no tiene password, esto significa que sólo el acceso a esa url es todo lo que se necesita para ver el área del cliente. Si quieres asegurar el área con una contraseña por favor editar este cliente y establecer una.',
  'kitchen:passphraseset' => 'Este cliente ha establecido una frase de contraseña',
  'kitchen:passphrase' => 'Frase de contraseña',
  'kitchen:description' => 'Esta es la URL para enviarle a tu cliente para que pueda acceder a la área de clientes, ahí podrá ver proyectos y facturas que hayas definido como visibles para él.',
  'kitchen:people_in_discussion' => 'Personas conversando',
  'kitchen:latest_invoice' => 'Última factura',
  'kitchen:unpaid_balance' => 'Balance sin pagar: :1',
  'kitchen:total_paid_to_date' => 'Total pagado a la fecha: :1',
  'store:store' => 'Tienda',
  'store:buy' => 'Comprar ($:1)',
  'store:update' => 'Actualizar',
  'store:install' => 'Instalar',
  'store:settings' => 'Configuración',
  'store:already_bought' => 'Ya habías comprado este ítem!',
  'store:installed_successfully' => 'Has instalado :1 :2 exitosamente.',
  'store:plugin' => 'Plugin',
  'store:payment_gateway' => 'Pasarela de Pago',
  'store:frontend_theme' => 'Tema de Frontend',
  'store:backend_theme' => 'Tema de Backend',
  'store:unknown' => 'Desconocido',
  'store:updatestoreitems' => 'Actualizar ítems de tienda',
  'store:download_free' => 'Descargar (Grátis)',
  'store:error1000' => 'Tu token de autorización ya no es válido. Usted tendrá que introducir sus datos de pago en pancakeapp.com una vez más.',
  'store:error1001' => 'Tu ya habías comprado este ítem en la tienda!',
  'store:error1002' => 'Un problema ocurrió mientras tratabamos de cargar el ítem a tu tarjeta de crédito. Por favor, intente nuevamente',
  'store:error1003' => 'Realizaste una petición inválida.',
  'email_templates:new_invoice' => 'Nueva factura',
  'email_templates:new_estimate' => 'Nuevo presupuesto',
  'email_templates:new_proposal' => 'Nueva propuesta',
  'email_templates:invoice_payment_notification_for_admin' => 'Notificación de pago (enviado al admin)',
  'email_templates:invoice_payment_notification_for_client' => 'Notificación de recibo de pago (enviada al cliente)',
  'email_templates:new_ticket' => 'Nuevo ticket',
  'email_templates:new_ticket_invoice' => 'Nueva factura de ticket',
  'email_templates:ticket_updated' => 'Notificación de actualización de Ticket',
  'email_templates:ticket_status_updated' => 'Notificación de actualización de estado de Ticket',
  'email_templates:assigned_to_task' => 'Notificación de asignación de tarea',
  'email_templates:assigned_to_milestone' => 'Notificación de asignación de hito',
  'email_templates:new_comment' => 'Nueva notificación de comentario',
  'global:timer_app' => 'Aplicación de tiempo',
  'invoices:lastreoccurrence' => 'Última reocurrencia: :1',
  'invoices:converted_to_estimate' => 'Factura #:1 convertida en presupuesto.',
  'global:converttoestimate' => 'Convertir a presupuesto',
  'tickets:view_archived' => 'Ver tickets archivados',
  'tickets:view_unarchived' => 'Ver tickets activos',
  'tickets:archiving_ticket' => 'Archivando ticket',
  'tickets:unarchiving_ticket' => 'Desarchivar ticket',
  'tickets:unknown_error_ticket_not_altered' => 'Un error ha ocurrido. El ticket no ha sido alterado.',
  'tasks:starting_timer' => 'Comenzando temporizador',
  'tasks:stopping_timer' => 'Parando temporizador',
  'global:all_comments' => 'Todos los comentarios',
  'dashboard:view_all_comments' => 'Ver todos los comentarios',
  'dashboard:latest_comments' => 'Ultimos comentarios',
  'dashboard:written_by' => 'Escrito por :1 el :2',
  'dashboard:client_activity' => 'Actividad del cliente',
  'dashboard:view_all_client_activity' => 'Ver toda la actividad de cliente',
  'dashboard:team_activity' => 'Actividad del equipo',
  'dashboard:view_all_team_activity' => 'Ver toda la actividad del equipo',
  'dashboard:my_tasks' => 'Mis tareas',
  'dashboard:view_all_my_tasks' => 'Ver todas mis tareas',
  'dashboard:what_the_team_is_working_on' => 'En lo que el equipo está trabajando.',
  'global:save_milestone' => 'Guardar hito',
  'global:save_task' => 'Guardar tarea',
  'global:private_comment' => 'Este comentario es privado, tu cliente no lo puede ver.',
  'global:clients_cant_see_private' => 'Los clientes no pueden ver comentarios privados.',
  'global:is_private' => 'Privado?',
  'tickets:disable_client' => '-- Deshabilitar tickets de soporte --',
  'global:css' => 'CSS personalizado',
  'global:js' => 'JavaScript personalizado',
  'global:js_explanation' => 'Puedes utilizar jQuery como quieras. Tu código será agregado justo antes de la etiqueta &lt;/body&gt;.',
  'settings:frontend_js' => 'JavaScript personalizado para el front',
  'settings:backend_js' => 'JavaScript personalizado para el Backend',
  'proposals:estimate_number_and_amount' => 'Presupuesto #:1 (:2)',
  'clients:delete' => 'Borrar cliente',
  'global:nolongerexists' => '[YA NO EXISTE]',
  'global:billed_amount' => 'Monto facturado',
  'global:unbilled_amount' => 'Monto sin facturar',
  'global:is_billed' => 'Facturado?',
  'settings:year_start' => 'Comienzo del año fiscal',
  'dashboard:since_explanation' => 'Desde el :1',
  'export:invoices_csv' => 'Facturas (CSV)',
  'projects:createdtemplate' => 'Plantilla de proyecto creado. Ahora puedes crear proyectos basados en esta plantilla.',
  'projects:delete_template' => 'Borrar plantilla',
  'projects:deleted_template' => 'Éxito! Plantilla eliminada.',
  'export:expenses_csv' => 'Gastos (CSV)',
  'export:clients_csv' => 'Clientes (CSV)',
  'projects:expense_date' => 'Fecha de gastos',
  'clients:can_create_support_tickets' => 'Permitir al cliente para crear tickets de soporte?',
  'tickets:submit_new' => 'Enviar ticket',
  'global:cancel' => 'Cancelar',
  'global:timers' => 'Contadores temporales',
  'global:more' => 'Más',
  'global:search' => 'Buscar',
  'authorize:api_login_id' => 'API Login ID',
  'authorize:api_login_id_description' => 'Puede encontrar esto en Authorize.net, bajo Account > API Login ID and Transaction Key.',
  'authorize:md5_hash' => 'MD5-Hash',
  'authorize:md5_hash_description' => 'Por defecto, este es tu ID de acceso de la API. Puedes cambiar esto en Authorize.net, bajo Account > MD5-Hash. Si tu ves  \'Hash Value Set: No\', deja eso en blanco.',
  'transactions:paymentfailed' => 'El pago ha fallado ',
  'transactions:extrapaymentfailed' => 'Ocurrido un problema inesperado al intentar procesar su pago. Por favor, póngase en contacto con :1 en :2 para asistencia.',
  'projects:tracked' => 'Agregado al historial',
  'invoices:partially_paid' => 'Parcialmente',
  'global:projects_ommitted' => ':1 proyectos no mostrados',
  'global:tasks_ommitted' => ':1 tareas no mostradas',
  'login:username_email' => 'Usuario / Email',
  'settings:when_new_updates_are_available' => 'Cuando hay nuevas actualizaciones disponibles',
  'settings:dont_install_just_notify_me' => 'No instalar, solo notificarme',
  'settings:install_automatically' => 'Instalar automáticamente',
  'settings:loading_update_details' => 'Cargando detalles de la actualización... Esto puede tomar un minuto o dos. Refresca en cualquier momento.',
  'settings:updating_please_wait' => 'Actualizando, por favor espere. Esta página se refescará automáticamente cuando la actualización haya sido realizada.',
  'settings:will_have_to_overwrite_single_file' => 'Pancake sobreescribirá 1 archivo que has modificado manualmente!',
  'settings:will_have_to_overwrite_multiple_files' => 'Pancake sobreescribirá :1 archivos que has modificado manualmente!',
  'settings:checking_for_updates' => 'Chequeando si hay actualizaciones disponibles, por favor espere. Esta página se refescará automáticamente.',
  'settings:description' => 'Guardar tus configuraciones actualizadas antes de cambiar de tab o dejar la página.',
  'settings:business_identities' => 'Identidades de negocio',
  'settings:business_name' => 'Nombre del negocio',
  'settings:new_business' => 'Nuevo negocio',
  'settings:business_identity' => 'Identidad del negocio',
  'settings:business_identity_explanation' => 'Tu cliente verá la identidad de la empresa por encima de todos sus correos electrónicos, archivos PDF y páginas',
  'settings:have_been_updated' => 'Las configuraciones han sido actualizadas.',
  'tasks:all' => 'Todas las tareas',
  'projects:progress' => 'Progreso',
  'expenses:name' => 'Nombre del gasto',
  'tasks:add_hours_to' => 'Agregar horas a :1',
  'global:today' => 'Hoy',
  'global:yesterday' => 'Ayer',
  'global:other' => 'Otro',
  'global:now' => 'Ahora',
  'timesheet:view_for_clients' => 'Ver listado de horas trabajadas (para clientes)',
  'global:not_billed_yet' => 'No cobradas aún.',
  'tasks:total_logged_time' => 'Tiempo total subido a la plataforma',
  'global:biweekly' => 'Cada dos semanas',
  'settings:default_task_due_date' => 'Fecha de vencimiento de tareas por defecto',
  'settings:default_task_due_date_explain' => 'días después de que la tarea se crea. Si no quieres una fecha predeterminada, dejar el campo vacío.',
  'global:timesheets' => 'Hojas',
  'timesheets:all_users' => 'Todos los usuarios',
  'timesheets:todays' => 'De hoy',
  'timesheets:rounded_time' => 'Redondeado al :1 más próximo',
  'timesheets:there_are_no_time_entries' => 'No hay entradas de tiempo para mostrar para este intervalo.',
  'expenses:sort_or_filter' => 'Ordenar/Filtrar Gastos',
  'global:there_is_no_activity' => 'No hay actividad de equipo para mostrar.',
  'global:there_are_no_tasks_assigned_to_you' => 'No hay tienes tareas asignadas.',
  'global:sort_by' => 'Ordenar por',
  'expenses:show' => 'Mostrar gastos',
  'global:sort_order' => 'Orden de clasificación',
  'global:desc' => 'Descendiendo (A-Z)',
  'settings:no_tax' => 'Sin impuestos',
  'global:asc' => 'Orden ascendente (A-Z)',
  'settings:default_taxes' => 'Impuestos por defecto',
  'global:tax' => 'Impuesto',
  'global:youarenotallowed' => 'No tiene permitido acceder a esta página.',
  'settings:tax_compound' => '¿Compuesto?',
  'settings:billing_email' => 'Correo electrónico asociado a la cuenta de facturación',
  'settings:brand_name' => 'Nombre de la Marca',
  'settings:brand_name_explanation' => 'Este es el nombre que quieres que tus clientes vean. Se mostrará en todas partes, excepto en las facturas.',
  'settings:show_name_along_with_logo' => '¿Mostrar el nombre de su marca junto a su logotipo?',
  'settings:admin_name_explanation' => 'Por defecto, este aparece al final de los correos electrónicos que envias a los clientes.',
  'settings:billing_email_explanation' => 'Esta es la dirección utilizada como "remitente" para los correos electrónicos de Facturas, Estimaciones y Propuestas.',
  'dashboard:snapshot' => 'Instantánea',
  'invoices:frequency' => 'Frecuencia',
  'settings:business_name_explanation' => 'Este es el nombre legal de su negocio. Se mostrará en sus facturas.',
  'dashboard:your_projects' => 'Tus proyectos',
  'invoices:send' => 'Enviar',
  'invoices:auto_send' => '¿Enviar automáticamente?',
  'dashboard:today' => 'Hoy',
  'settings:always_https' => '¿Forzar HTTPS?',
  'settings:notify_email_explanation' => 'Esta es la dirección "Desde" utilizada para las notificaciones de comentarios y para tickets de soporte.',
  'invoices:days_before_invoice_is_due' => 'días antes de factura es debido a',
  'settings:always_https_explanation' => 'Esto va a hacer que Pancake cargue siempre a través de HTTPS. Utilice esto sólo si tiene un certificado SSL instalado y puede acceder a Pancake a través de HTTPS.',
  'invoices:mail_to' => 'Enviar a',
  'invoices:cannot_change_recurrences' => 'No puedes cambiar los ajustes de repetición de una factura que a su vez es la repetición de otra factura.',
  'clients:you_cannot_send' => 'No puedes enviarle a este cliente sus detalles del área de clientes por correo electrónico porque este cliente no tiene una dirección de correo electrónico.',
  'email_templates:client_area_details' => 'Detalles del Área de Clientes',
  'invoices:discount' => 'Descuento',
  'clients:send_client_area_email' => 'Enviar detalles del área de clientes',
  'settings:remittance_slip' => 'Cobro',
  'invoices:discount_explain' => 'Añadir % para los porcentajes.',
  'credit_notes:edit_credit_note' => 'Editar Nota de Crédito #:1',
  'credit_notes:create_credit_note' => 'Crear una Nota de Crédito',
  'global:credit_notes' => 'Notas de Crédito',
  'global:credit_note' => 'Nota de crédito',
  'credit_notes:alltitle' => 'Todas las Notas de Crédito',
  'credit_notes:edit' => 'Editar la nota de crédito',
  'credit_notes:delete_message' => '¿Está seguro de que quiere eliminar esta nota de crédito?',
  'credit_notes:no_credit_notes' => 'Usted no tiene Notas de Crédito.',
  'credit_notes:create' => 'Crear Nota de Crédito',
  'credit_notes:delete_title' => '¿Eliminar esta nota de crédito?',
  'credit_notes:nocredit_notesforthefilteredclient' => 'Usted no tiene notas de crédito para :1.',
  'credit_notes:send_now_title' => '¿Enviar la nota de crédito ahora?',
  'credit_notes:no_credit_notes_body' => '¡Deberías apuntarte a eso! ¿Te gustaría crear una ahora?',
  'credit_notes:send_now' => 'Enviar la nota de crédito',
  'credit_notes:credit_note_number' => 'Nota de Crédito #:1',
  'credit_notes:credit_note_date' => 'Fecha de la nota de crédito',
  'credit_notes:preview' => 'Previsualizar la nota de crédito',
  'email_templates:new_credit_note' => 'Nueva nota de crédito',
  'clients:view' => 'Ver cliente',
  'credit_notes:duplicated' => 'La nota de crédito está duplicada #:1. El número de la nueva nota de crédito es #:2.',
  'global:success' => '¡Éxito!',
  'clients:credit_balance_currently' => 'Balance de crédito (actualmente :1)',
  'invoices:make_bulk_payment' => 'Haz pagos múltiples',
  'credit_notes:send_now_body' => 'Rellene el siguiente formulario y le entregaremos esta nota de crédito.',
  'invoices:x_invoices' => ':1 facturas',
  'invoices:amount_to_pay' => 'Cantidad para marcar como pagada',
  'credit_notes:addedconf' => 'Ha añadido la nota de crédito # <strong>:1</strong>, por un total de <strong>:2</strong> (:3 con impuestos) para :4:5.',
  'invoices:send_bulk_payment_notification' => '¿Enviar notificaciones de correos electrónicos de los pagos al cliente?',
  'global:credit_balance' => 'Balance de crédito',
  'credit_notes:client_viewed' => ':1 vio <a href=":2">nota de crédito #:3</a> el :4',
  'invoices:bulk_payment_added' => 'Los pagos se han añadido con éxito.',
  'invoices:send_payment_notification' => '¿Enviar una notificación del pago mediante correo electrónico al cliente?',
  'invoices:specify_bulk_payment_details' => 'Especifique los detalles de los pagos de su cliente, y seleccione las facturas a las cuales se aplican los pagos.',
  'clients:has_no_unpaid_invoices' => ':1 no tiene facturas sin pagar.',
  'credit_notes:view' => 'Ver nota de abono.',
  'invoices:store_bulk_payment' => 'Guardar Varios Pagos',
  'settings:ticket_status_for_sending_invoice' => 'Estado de los tickets para la facturación.',
  'expenses:added' => 'El gasto fue añadido con éxito.',
  'settings:ticket_status_for_sending_invoice_description' => 'Cuando un ticket pagado se actualiza a éste estado, una factura se generará automáticamente y será enviada al cliente.',
  'tickets:ticket_number' => 'Ticket #:1',
  'global:incorrect_login' => 'La combinación de nombre de usuario/contraseña que ha introducido no es válida.',
  'settings:hide_tax_column' => '¿Ocultar columna de impuestos?',
  'global:error_submitting_ajax' => 'Se produjo un error desconocido tratando de enviar este formulario. Por favor, intente de nuevo más tarde. Si el error persiste, por favor, inicie un ticket de soporte gratuito en pancakeapp.com.',
  'invoices:send_to_client' => 'Enviar Factura vía correo electrónico al cliente',
  'invoices:sub_total_after_discounts' => 'Subtotal (después de los descuentos)',
  'global:beforeunload' => 'Estás a punto de salir de esta página. Si lo haces, se perderán todos los datos que has introducido hasta ahora. ¿Estás seguro de que quieres salir de esta página?',
  'global:unanswered' => 'Sin respuesta',
  'global:accepted' => 'Aceptado',
  'tickets:not_yet_generated' => 'Factura no generada todavía',
  'estimates:accepted' => 'Aceptaciones estimadas',
  'store:error1004' => 'Se produjo un error desconocido al tratar de adquirir este artículo. Por favor, inténtelo de nuevo más tarde. Si el error persiste, por favor contacte gratuitamente con atención al cliente en pancakeapp.com.',
  'settings:never_send_ticket_invoices_automatically' => '- Nunca envíe facturas automáticamente',
  'clients:update_balance' => 'Actualizar balance de crédito',
  'estimates:unanswered' => 'Estimaciones sin respuesta',
  'global:appendtoproject' => 'Convertir en tareas para ":1"',
  'items:percentage_discount' => 'Descuento (%)',
  'global:rejected' => 'Rechazado',
  'estimates:rejected' => 'Rechazos estimados',
  'items:fixed_discount' => 'Descuento (:1)',
  'clients:add_custom_field' => 'Añadir otro campo personalizado',
  'clients:balance_updated' => 'Éxito! El saldo de crédito de cliente se actualizó con éxito.',
  'invoices:discount_percentage' => 'Descuento (:1%)',
  'expenses:attach_receipt' => 'Adjuntar Recibo (Tamaño máximo: :1)',
  'estimates:send_to_client' => 'Correo electrónico estimado del cliente.',
  'settings:hide_tax_column_explanation' => 'Esto ocultará la columna de impuestos en las facturas que no tienen información fiscal.',
  'clients:no_amount_specified' => 'No has especificado una cantidad.',
  'clients:tax_registration_number' => ':1 Número / ID',
  'expenses:receipt' => 'Recibo',
  'global:triennially' => 'Trienalmente',
  'invoices:pancake_will_automatically_change_is_viewable' => 'Esto cambiará a "sí" automáticamente cuando se envíe  la factura al cliente por correo electrónico.',
  'expenses:category_added' => '¡Éxito! La categoría de gastos fue creada satisfactoriamente.',
  'clients:what_do_you_want_to_do' => '¿Qué quiere hacer?',
  'expenses:no_receipt' => 'Sin recibo',
  'estimates:appended' => 'Conversión estimada #:1 en tareas de ":2".',
  'tickets:invoice_will_be_generated' => 'Una factura de :1 para éste ticket se generará cuando el estado del ticket cambie a ":2".',
  'emailtemplates:content' => 'Contenido del correo electrónico',
  'reports:verb_created' => 'Creado',
  'reports:verb_paid' => 'Pagado',
  'reports:verb_from_to' => ':1 desde :2 a :3',
  'reports:payments' => 'Pagos',
  'expenses:edited' => '¡Éxito! El gasto fue editado satisfactoriamente.',
  'dashboard:upcoming_invoices' => 'Próximas facturas',
  'error:unknown_error_reporting' => 'Ocurrió un error desconocido. Por favor, informe de este error manualmente.',
  'error:sending_details' => 'Enviando los detalles...',
  'clients:save_balance_alteration' => 'Guardar la alteración del balance',
  'settings:errors_and_diagnostics' => 'Errores y Diagnósticos',
  'expenses:expense_receipts' => 'Recibos de gastos',
  'expenses:no_project_business_expense' => 'Gastos del negocio (No del proyecto)',
  'clients:tax_numbers' => 'Número de identificación fiscal de los clientes / documentos de identidad',
  'dashboard:there_are_no_upcoming_invoices' => 'No hay nuevas facturas para mostrar.',
  'error:subtitle' => 'Se ha producido un error desconocido.',
  'error:title' => 'Error desconocido',
  'error:already_reported' => 'Este error ya se ha reportado al soporte de Pancake.',
  'error:not_logged_in_intro' => 'Estos errores se registran automáticamente.',
  'error:not_logged_in_extra' => 'Si el problema persiste, por favor póngase en contacto con :1.',
  'expenses:expense_date' => 'Fecha',
  'clients:custom_fields' => 'Campos personalizados',
  'errors:report' => 'Informe del error',
  'reports:amount_paid' => 'Importe del pago',
  'errors:subject' => 'Título erróneo',
  'global:once' => 'Una vez',
  'settings:delete_error' => 'Eliminar error',
  'global:x_times' => ':1 veces',
  'global:twice' => 'Dos veces',
  'errors:number_of_occurrences' => 'numero de ocurrencias',
  'settings:report_error' => 'Informe del error',
  'error:logged_in_extra' => 'Haga clic aquí para enviar un ticket de soporte gratuito con los detalles del error al Equipo de Soporte de Pancake.',
  'global:occurred_times' => 'Ocurrió :1',
  'error:reporting' => 'Reportando...',
  'projects:role_delete' => 'Eliminar',
  'error:response_will_be_sent_to_email' => 'Se le notificarán las respuestas en {email}.',
  'projects:role_view' => 'Ver',
  'settings:error_reported' => 'Error reportado',
  'error:cannot_send_error_details' => 'No puedes enviar los detalles del error al equipo de soporte de Pancake porque no estás conectado.',
  'projects:role_edit' => 'Editar',
  'projects:role_edit_task' => 'Editar tarea',
  'settings:view_error_details' => 'Ver detalles del error',
  'clients:noclientbodyfiltered' => 'Ninguno de los nombres de sus clientes comienza con ":1".',
  'error:deleting' => 'Borrando...',
  'projects:role_track_time' => 'Tiempo de seguimiento',
  'error:no_logged_errors' => 'No tiene errores registrados.',
  'projects:role_add_milestone' => 'Añadir hito',
  'projects:role_create' => 'Crear',
  'projects.title' => 'Proyectos',
  'projects:role_add_task' => 'Añadir tarea',
  'projects.edit.title' => 'Actualizar proyecto',
  'projects.create.title' => 'Crear proyecto',
  'tickets:unarchive' => 'Restaurar',
  'global:errors' => 'Errores',
  'projects.button.create' => 'Crear proyecto →',
  'projects:role_delete_milestone' => 'Eliminar Milestone',
  'projects.label.client' => 'Cliente:',
  'error:logged_in_intro' => 'Estos errores se almacenan en el panel de administración, en \'Ajustes > Errores & Diagnósticos\'.',
  'projects.label.description' => 'Descripción:',
  'projects.label.name' => 'Nombre:',
  'projects.update.succeeded' => '¡El proyecto se ha actualizado!',
  'projects.label.is_viewable' => '¿Visible en el área de clientes?',
  'projects.delete.title' => '¿Está seguro de que quiere eliminar este proyecto?',
  'projects.label.due_date' => 'Fecha de vencimiento:',
  'projects.create.succeeded' => '¡El proyecto ha sido creado!',
  'times.label.end_time' => 'Hora de finalización:',
  'times.label.start_time' => 'Hora de inicio:',
  'projects.button.delete' => 'Eliminar proyecto →',
  'projects:role_edit_milestone' => 'Editar hito',
  'times.button.create' => 'Añadir Tiempo→',
  'projects.label.rate' => 'Tarifa por hora:',
  'times.create.title' => 'Añadir tiempo',
  'projects:role_delete_task' => 'Borrar tarea',
  'error:cant_send_email' => 'No se puede enviar el correo electrónico',
  'error:not_enough_disk_space_explanation' => 'Su servidor de base de datos (:1) no tiene suficiente espacio en disco.',
  'times.create.succeeded' => '¡El tiempo ha sido introducido con éxito!',
  'error:not_enough_disk_space' => 'No hay espacio suficiente en el disco',
  'times.label.notes' => 'Notas:',
  'times.title' => 'Cantidad de veces',
  'times.label.date' => 'Fecha:',
  'tickets:archive' => 'Archivo',
  'projects.button.edit' => 'Actualizar el proyecto →',
  'times.label.note' => 'Nota:',
  'error:email_settings_not_valid' => 'La configuración de su correo electrónico no es válida.',
  'error:cant_send_email_explanation' => 'Ha especificado que desea utilizar Sendmail (:1) para enviar correos electrónicos, pero no fue posible hacerlo. O la ruta a Sendmail es incorrecta, o algo más ha ido mal.',
  'error:server_error' => 'Error en el servidor',
  'error:permissions_not_valid' => 'Hay un problema con los permisos del archivo en su servidor.',
  'global:estimates_unsent' => 'No enviado',
  'times.edit.succeeded' => '¡La hora ha sido editada con éxito!',
  'error:xcache_extension_broken' => 'Su servidor tiene un problema con la extensión XCache.',
  'error:no_tmp_dir_permissions_explanation' => 'Su servidor está configurado de tal manera que no permite a Pancake crear archivos temporales en <code>:1</code>.',
  'invoices:see_payment_schedule' => 'Ver Programa de Pagos',
  'times.label.task_id' => 'Tarea:',
  'error:page_not_found' => 'Página no encontrada',
  'error:cant_send_email_solutions' => 'Si tiene acceso de administrador (root) al servidor, asegúrese de tener sendmail instalado y trate de encontrarlo con <code>sendmail</code>.',
  'error:not_enough_disk_space_solutions' => 'Si tiene acceso root al servidor de la base de datos, pruebe vaciando /tmp. Si eso no funciona, revise el uso del espacio del disco duro en su servidor de base de datos, y trate de liberar un poco de espacio del disco duro.',
  'error:page_does_not_exist' => 'La página a la que estaba tratando de acceder no existe.',
  'invoices:see_payment_schedule_below' => 'Ver Programa de Pagos debajo',
  'error:xcache_extension_broken_explanation' => 'Algo salió mal mientras su servidor estaba tratando de cargar la extensión XCache. Esto no está relacionado con Pancake en absoluto, pero está impidiendo que se ejecute Pancake.',
  'error:no_tmp_dir_permissions_solutions' => 'Si tiene acceso root al servidor, puede cambiar el ajuste <code>open_basedir</code> en su php.ini para que <code>:1</code> se incluya en la lista de carpetas permitidas.',
  'error:page_does_not_exist_explanation' => 'Estaba intentando acceder a :1, pero no existe. Si éste error es inesperado, puede informar del error al Equipo de Soporte de Pancake. Lo encontrarás en \'Ajustes &gt; Errores &amp; Diagnosticos.',
  'projects:no_data_provided' => 'Usted no ingresó ninguna información para crear un proyecto a partir de una plantilla.',
  'error:you_cannot_report_this_error' => 'No puede informar de este problema al soporte de Pancake, ya que es un problema con su servidor. Por favor, póngase en contacto con el administrador de su servidor acerca de este problema. Cuando lo discuta con ellos, dígales:',
  'reports:per_payment_method' => 'por la forma de pago',
  'settings:importedcredit_notes' => 'Importadas con éxito :1 Notas de Crédito.',
  'projects:invalid_template' => 'No seleccionó una plantilla válida para el proyecto.',
  'gateways:just_for_logging' => 'Nota: Esta forma de pago no afecta a las facturas de ninguna manera.<br/>Está aquí para que pueda realizar un seguimiento de los pagos recibidos por :1.',
  'settings:test_email_message' => 'Este es un correo electrónico de prueba. Si has recibido esto, significa que los correos electrónicos están funcionando en Pancake.',
  'settings:sending' => 'Enviando correo electrónico...',
  'kitchen:responses' => 'Respuestas',
  'settings:test_email_sent' => 'Enviado al :1 correctamente!',
  'expenses:supplier_added' => '¡Éxito! El proveedor fue creado con éxito.',
  'kitchen:no_tickets_created' => 'No hay tickets creados.',
  'projects:add_new_task' => 'Añadir nueva tarea',
  'kitchen:x_responses' => ':1 Respuestas',
  'settings:test_email_error_header' => 'Error al enviar mensaje de prueba',
  'projects:delete_project_template' => 'Eliminar la plantilla del proyecto',
  'expenses:category_name' => 'Nombre de la categoría',
  'expenses:supplier_name' => 'Nombre del proveedor',
  'settings:send_test_email' => 'Enviar un correo electrónico de prueba',
  'items:select_flat_rate' => 'Tarifa Plana',
  'invoices:all_unpaid' => 'Todos sin pagar',
  'settings:test_email_error' => 'Se produjo un error al tratar de enviar el correo electrónico de prueba:<br/><br/>:1<br/><br/>Por favor, asegúrese de que los datos introducidos son correctos. Si está utilizando SMTP, asegúrese de que el puerto que está intentando usar está abierto en el cortafuegos de su servidor.',
  'global:show_hide_deleted' => 'Mostrar / ocultar borrados',
  'settings:test_email_connection_error' => 'Su servidor no puede conectarse a :1 en el puerto :2. Tendrá que ponerse en contacto con el administrador del sistema y permitir este puerto en el cortafuegos de su servidor.<br/><br/>El mensaje de error fue:<br/><br/>:3',
  'settings:test_email_subject' => 'Este es un email de prueba.',
  'expenses:supplier_edited' => '¡Correcto! El proveedor fue editado correctamente.',
  'error:cant_php_mail_explanation' => 'Ha especificado que quiere usar PHP mail () para enviar correos electrónicos, pero este método de envío de correo electrónico no está funcionando correctamente en su servidor. Este método de envío de correo electrónico no requiere configuración, pero no se recomienda porque los servidores de correo electrónico no pueden verificar quién está enviando el correo. Algunos de ellos incluso marcarán automáticamente sus correos electrónicos como spam. Cambie las opciones de su servidor de correo electrónico en el apartado de administrador, en "Configuración > Correos eléctronicos", para usar una de las opciones SMTP, y si no puede, utilice la opción Sendmail como último recurso. Si ninguna de estas opciones funciona, tendrá que contactar con su administrador de servidor.',
  'reminders:no_due_date' => 'Sin fecha de vencimiento',
  'search:results_for_x' => 'Resultados de búsqueda para ":1"',
  'expenses:category_edited' => '¡Éxito! La categoría fue editada satisfactoriamente.',
  'global:project_task' => 'Tarea',
  'global:ticket' => 'Ticket',
  'search:x_matching_results' => ':1 resultados coincidentes',
  'search:one_matching_result' => '1 resultado coincidente',
  'tickets:added' => 'El ticket ha sido creado con éxito.',
  'tickets:replied' => 'Tu respuesta al ticket fue guardada correctamente.',
  'reminders:x_days_past_due' => ':1 días vencidos',
  'global:project_expense' => 'Gasto',
  'global:reply' => 'Respuesta',
  'expenses:before_you_can_add_expenses' => 'Antes de poder añadir cualquier gasto, es necesario crear algunos :1 y :2.',
  'users:deactivate' => 'Desactivar',
  'global:download_csv' => 'Descargar CSV',
  'tickets:user_updated_ticket' => ':1 actualizó el estado del ticket a :2 sobre :3',
  'reports:collected' => 'Recogido',
  'clients:filter_clients' => 'Filtrar clientes',
  'reports:uncollected' => 'No cobradas',
  'global:attach_file' => 'Adjuntar un fichero (Tamaño máximo: :1)',
  'users:activate' => 'Activar',
  'global:group' => 'Grupo',
  'users:confirm_password' => 'Confirmar contraseña',
  'tasks:add_notes' => 'Añadir notas',
  'users:edit_user' => 'Editar usuario',
  'invoices:not_associated_with_a_project' => '- Sin asociar a un proyecto -',
  'global:by_x_with_time' => 'Por :1, :2.',
  'projects:hourly_rate' => 'Tarifa por hora',
  'tasks:complete_this_task' => 'Completar esta tarea',
  'users:please_enter_information' => 'Por favor, introduzca la información del usuario a continuación.',
  'global:bcc_was_sent_to' => 'Este correo electrónico se ha enviado a :1 el :2.',
  'global:server_default' => 'Servidor por defecto (no recomendado)',
  'tickets:active_tickets' => 'Tickets activos',
  'tasks:discuss_task' => 'Discutir la tarea',
  'projects:rate_type' => 'Tipo de tarifa',
  'tickets:leave_a_response' => 'Dejar una respuesta',
  'tasks:task_notes' => 'Notas de tarea',
  'error:already_being_dealt_with' => 'El problema ya ha sido reportado por otra persona, y está siendo tramitado. Estamos trabajando para resolverlo lo antes posible.',
  'error:no_user_found' => 'Su clave de licencia no está asociada a ningún usuario de pancakeapp.com, por lo que su error no pudo ser enviado automáticamente. Si esto es inesperado, envíe un correo electrónico a support@pancakeapp.com y le ayudaremos.',
  'error:fixed_in_version' => 'Este problema se arregló en Pancake {version}. Si todavía no la tienes, actualiza tu Pancake.',
  'global:and' => 'Y',
  'error:php_outdated' => 'La versión de PHP que estás utilizando está desactualizada.',
  'error:pancake_will_stop_supporting_it' => 'Pancake podría dejar de soportarlo en cualquier momento.',
  'error:scanning' => 'Escaneando, por favor espere...',
  'error:using_php_53' => 'Estás utilizando PHP 5.3, que ha estado desactualizado desde julio de 2013 y ya no está soportado por el Grupo PHP.',
  'error:upgrade_php' => 'Usted debe actualizar su versión de PHP a la versión 5,5 como mínimo (la idónea es 5.6). Para hacerlo, por favor hable con su administrador del servidor y pídale que actualice PHP.',
  'error:scan_result_success' => 'Tu Pancake está en perfecto estado y no ha sido alterado de ninguna manera. Todo está correcto.',
  'error:unknown_error_scanning' => 'Se produjo un error desconocido mientras se escaneaba.',
  'error:scan' => 'Escanear',
  'error:scan_result_failure_deleted_one' => 'El archivo ":1" no existe',
  'error:scan_result_failure_deleted_other' => 'Archivos tipo :1 no existen.',
  'error:scan_result_failure_modified_one' => 'Un :1 del archivo ha sido modificado.',
  'error:why_update' => 'Siguiendo con esta versión de PHP, te estás perdiendo una serie de mejoras de rendimiento y seguridad, así como muchas correcciones de errores.',
  'error:click_here_for_instructions' => 'Haga clic aquí para ver las instrucciones',
  'error:using_php_54' => 'Estás utilizando PHP 5.4, que está desactualizado desde septiembre de 2014 y ya no es soportado por el Grupo PHP.',
  'error:scan_pancake' => 'Escanee su Pancake por incidencias relacionadas con los archivos.',
  'error:scan_result_failure_heading' => 'Hay problemas con tus archivos de Pancake.',
  'error:scan_result_failure_how_to_fix' => 'Para resolver estos problemas, tendrá que actualizar manualmente sus archivos de Pancake.',
  'error:scan_result_failure_modified_other' => 'Se han modificado :1 archivos',
  'error:and_x_others' => '... y los :1 demás.',
  'global:archived' => 'Archivado',
  'proposals:archived' => 'Has archivado la propuesta #:1 con éxito.',
  'global:restore' => 'Restaurar',
  'invoices:archived' => 'Has archivado la factura #:1 con éxito.',
  'proposals:restored' => 'Has restaurado la propuesta #:1 con éxito.',
  'invoices:restored' => 'Has restaurado la cuenta en un #:1 con éxito.',
  'global:archive' => 'Archivar',
  'estimates:archived' => 'Has archivado el presupuesto #:1 con éxito.',
  'estimates:restored' => 'Has restaurado aproximadamente un #:1 con éxito.',
  'credit_notes:archived' => 'Has archivado la nota de crédito #:1 con éxito.',
  'proposals:list_all' => 'Todas las Propuestas',
  'credit_notes:restored' => 'Has restaurado la nota de crédito #:1 con éxito.',
  'proposals:list_accepted' => 'Propuestas Aceptadas',
  'error:scan_pancake_explanation' => 'A veces podrían surgir problemas a causa de una actualización fallida o debido a los problemas de permisos que causan que tus archivos de Pancake se corrompan durante una actualización. Usa esto para comprobar tu Pancake ante cualquier tipo de problemas.',
  'proposals:list_archived' => 'Propuestas Archivadas',
  'proposals:list_unanswered' => 'Propuestas sin respuesta. ',
  'proposals:list_rejected' => 'Propuestas Rechazadas',
  'invoices:credit_notes_archived' => 'Notas de Abono Archivadas',
  'invoices:invoices_archived' => 'Facturas Archivadas',
  'invoices:estimates_archived' => 'Estimaciones Archivadas',
  'estimates:estimates_unsent' => 'Estimaciones no enviadas',
  'tickets:link_to_ticket' => 'Enlace al boleto: :1',
  'tickets:invoice_for_ticket' => 'Boleto #:1 - :2',
  'dashboard:outstanding_invoices' => 'Facturas Pendientes',
  'dashboard:view_all_outstanding_invoices' => 'Ver todas las facturas pendientes',
  'expenses:missing_category' => 'No seleccionó una categoría.',
  'expenses:missing_supplier' => 'Usted no ha seleccionado un proveedor.',
  'error:update_system' => 'Error de actualización',
  'error:update_system_cannot_update_file' => 'Pancake fue incapaz de modificar uno o más de sus archivos durante la actualización.',
  'error:update_system_cannot_update' => 'Pancake fue incapaz de descargar la actualización correctamente.',
  'error:update_system_solutions' => 'La actualización no se pudo completar, y su Pancake puede estar en estos momentos en un estado parcialmente actualizado, lo que le causará errores. Usted tendrá que actualizar manualmente sus archivos Pancake para resolver el problema. <br/><br/> :1 <br/><br/> Estos errores pueden ocurrir debido a un problema con los permisos de archivos. Si Pancake no tiene acceso de escritura a todos sus archivos, no es capaz de actualizarse a sí mismo correctamente. En la mayoría de los servidores, esto se maneja de forma automática, pero un pequeño número de servidores podría requerir intervención manual.',
  'error:update_without_ftp' => 'Si usted no tiene acceso al FTP (o no desea utilizar el FTP), pero tienes acceso al SSH de tu Pancake, <a class="blue-btn" href="https://www.pancakeapp.com/faq/update-without-ftp" target="_blank">haz click aquí</a> para aprender cómo actualizar sin FTP.',
  'proposals:missing_client' => 'No has seleccionado un cliente.',
  'gateways:direct_debit' => 'Débito directo',
  'error:no_permissions_solutions' => 'Puedes resolver esto permitiendo que la carpeta sea editable. Por lo general, esto se hace con CHMOD 0777, pero puede haber otras maneras (por ejemplo, a través del panel de control del tu hosting web).',
  'error:you_cannot_report_this_non_server_error' => 'No puedes reportar este problema al Soporte de Pancake porque este no es un problema con Pancake.',
  'error:no_permissions_explanation' => 'Pancake no tiene permiso para crear archivos en <code>:1</code>.',
  'settings:decimal_places' => ':1 posiciones decimales',
  'settings:currency_format' => 'Formato de moneda',
  'settings:no_notify_email' => 'Usted no tiene una dirección de correo electrónico establecida para la <a href=":1">identidad de su empresa</a>.<br/>Pancake no puede enviar correo electrónico.',
  'settings:add_another_business' => 'Añadir otro negocio',
  'global:auto_send_needs_pancake_cron_job' => 'Para enviar automáticamente las facturas, se debe configurar el <a href="https://www.pancakeapp.com/documentation/cron" target="_blank">Pancake Cron Job</a>.',
  'settings:always_autosend' => 'Envío automático de facturas de forma predeterminada',
  'invoice:description' => 'Descripción',
  'invoices:auto_charge' => 'Cargar al cliente automáticamente',
  'global:or' => 'o',
  'invoices:charge_when_due' => 'Cobrar Cuando Sea Debido',
  'invoices:pancake_will_charge_when_invoice_is_due' => 'Pancake le cobrará automáticamente a este cliente cuando esté la factura, utilizando sus datos de pago guardados.',
  'invoices:could_not_auto_charge' => 'Pancake no ha podido cobrar automáticamente a su cliente. Su cliente tendrá que pagar la factura #:1 de forma manual.',
  'invoices:auto_charged' => 'A su cliente se le ha cobrado la factura #:1. La factura ya está pagada.',
  'settings:gmail_setup_successfully' => '¡Has conectado con éxito tu Pancake con tu cuenta de Gmail!',
  'credit_notes:messageupdated' => '¡La nota de crédito se ha actualizado!',
);
/** End of file: pancake_lang.php **/
