<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Pancake
 * A simple, fast, self-hosted invoicing application
 *
 * @package     Pancake
 * @author      Michela Cappelli lamikk@email.it
 * @copyright   Copyright (c) 2010, Pancake Payments
 * @license     http://pancakeapp.com/license
 * @link        http://pancakeapp.com
 * @since       Version 1.0
 */
// ------------------------------------------------------------------------
$lang = array(
    /** Global Words **/
    'global:overview' => 'Riepilogo',
    'global:error' => 'Errore',
    'global:pancakeby7am' => 'Pancake :1',
    'global:allrelatedmediacopyright' => 'Pancake e Tutti i Media Relativi sono coperti da Copyright :1 :2',
    'global:insecure_action' => 'Tentativo di Operazione non Sicura Bloccato',
    'global:disabled_in_demo' => 'Alcune funzioni di questa pagina sono disabilitate nella versione Demo.',
    'global:estimates' => 'Preventivi',
    'global:estimate' => 'Preventivo',
    'global:incomplete_tasks' => 'Attività Incomplete',
    'global:completed_tasks' => 'Attività Completate',
    'global:projects' => 'Progetti',
    'global:tickets' => 'Tickets',
    'global:project' => 'Progetto',
    'global:upload_failed' => 'Si è verificato un problema nel caricamento del file. Per favore prova di nuovo. Se il problema persiste contatta support@pancakeapp.com.',
    'global:upload_not_allowed' => 'Il tipo di file che stai provando a caricare non è consentito. Se necessiti effettuare l\'upload di questo tipo di file, per favore comprimilo in un file .zip o qualsiasi altro formato di archivio che ritieni appropriato.',
    'global:copied' => 'Copiato!',
    'global:sentbutunpaid' => 'Sospeso (Inviato ma Insoluto)', //is °overdue sent but not paid°  singular or plural? this translation is for singular
    'global:task' => 'Attività',
    'global:clients' => 'Clienti',
    'global:access_denied' => "Accesso Negato",
    'global:users' => 'Utenti',
    'global:send_to_client' => 'Invia al Cliente',
    'global:couldnotsendemail' => 'Impossibile inviare email. Per favore controllo le impostazioni.',
    'global:emailsent' => 'Email inviata!',
    'global:yes' => 'SI',
    'global:no' => 'No',
    'global:notyetsent' => 'Non inviata al Cliente',
    'global:dontshowagain' => "Non mostrare di nuovo",
    'global:enable' => 'Abilita',
    'global:is_enabled' => 'Abilitato?',
    'global:is_completed' => 'Completato?',
    'global:Y' => 'Y',
    'global:N' => 'N',
    'global:notes' => 'Note',
    'global:description' => 'Descrizione',
    'global:backtoadmin' => 'Torna a Admin',
    'global:type' => 'Tipo',   //does °type° here stands for character typing or is it a synonym of kind?
    'global:name' => 'Nome Completo',
    'global:first_name' => 'Nome',
    'global:last_name' => 'Cognome',
    'global:company' => 'Azienda',
    'global:for' => 'per',
    'global:from' => 'da',
    'global:phone' => 'Telefono',
    'global:email' => 'Email',
    'global:contacts' => 'Contatti',
    'global:week' => 'Settimanale',
    'global:na' => 'N/A',
    'global:quarterly' => 'Trimestrale',
    'global:statistics' => "Statistiche",
    'global:month' => 'Mensile',
    'global:year' => 'Annuale',
    'global:fax' => 'Fax',
    'global:mobile' => 'Mobile',
    'global:address' => 'Indirizzo',
    'global:api_key' => 'API Key',
    'global:website' => 'Website',
    'global:action' => 'Action', //I should see it in its context to translate it correctely or just tell me where it is used
    'global:items' => 'Voci',
    'global:reusableinvoiceitems' => 'Voci di Fatturazione Riutilizzabili',
    'global:reusableinvoiceitems_description' => 'Dovresti usare "Voci di Fatturazione Riutilizzabili" quando desideri reinserire lo stesso elemento in differenti fatture. Per utilizzarlo, quando stai creando o modificando una fattura, inizia sempplicemente a scrivere il nome della voce salvata e sarà proposto un autocompletamento dei dettagli.',
    'global:create_invoice_estimate' => 'Crea Fatture e Preventivi per riscuotere denaro.',   //is create invoices and estimates a command as in create invoice or description of a feature?
    'global:createinvoice' => 'Crea Fattura',
    'global:paid' => 'Pagate',
    'global:unpaid' => 'Insolute',
    'global:overdue' => 'Scadute',
    'global:time_entries' => 'Registri Tempo',
    'global:invoices' => 'Fatture',
    'global:invoice' => 'Fattura',
    'global:tasks' => 'Attività',
    'global:dashboard' => 'Dashboard',
    'global:settings' => 'Impostazioni',
    'global:plugins' => 'Plugins',
    'global:installed' => 'Installato',
    'global:changepassword' => 'Cambio Password',
    'global:logout' => 'Disconnessione',
    'global:status' => 'Stato',
    'global:client' => 'Cliente',
    'global:user' => 'Utente',
    'global:title' => 'Titolo',
    'global:subtitle' => 'Sottotitolo',
    'global:to' => 'A (separare indirizzi multipli con una virgola)',
    'global:subject' => 'Oggetto',
    'global:thanks' => 'Grazie!',
    'global:proposals' => 'Proposte',
    'global:proposal' => 'Proposta',
    'global:reports' => 'Reports',
    'global:item' => 'Voce',
    'global:report' => 'Report',
    'global:saveandinsert' => 'Salva e Inserisci',
    'global:details' => 'Dettagli',
    'global:license_key' => 'License Key',
    'global:version' => 'Versione :1',
    'global:content' => 'Contenuto',
    'global:add' => 'Aggiungi',
    'global:edit' => 'Modifica',
    'global:resend' => 'Reinvia',
    'global:sent' => 'Inviato',
    'global:not_sent' => 'Non inviato',
    'global:view' => 'Vedi',
    'global:delete' => 'Cancella',
    'global:remove' => 'Rimuovi',
    'global:sort' => 'Ordina',
    'global:deleteitem' => 'Cancella Voce',
    'global:dragtoreorder' => 'Trascina per Riordinare',
    'global:start' => 'Start',
    'global:stop' => 'Stop',
    'global:start_timer' => 'Start Timer',
    'estimates:create' => "Crea Preventivo",
    'global:stop_timer' => 'Stop Timer',
    'global:created' => 'Creato',
    'global:updated' => 'Aggiornato',
    'global:update' => 'Aggiornamento',
    'global:update_available' => ':1 Aggiornamento Disponibile',
    'global:updates_available' => ':1 Aggiornamenti Disponibili',
    'global:downloadpdf' => 'Download PDF',
    'global:yesdelete' => 'Sì, cancella!',
    'global:confirm_emphisised' => 'Non si può tornare indietro!',
    'global:color' => 'Colore',
    'global:save' => 'Salva',
    'global:unknown' => 'Sconosciuto',
    'global:upload_ini_size' => 'Il file caricato supera il limite di dimensioni imposto dalla tua installazione di PHP.',
    'global:upload_error' => 'Errore durante il caricamento del file. Riprova.',
    'global:recurring' => 'Ricorrente',
    'global:unsent' => 'Non Inviato',
    'global:converttoproject' => 'Converti in Progetto',
    'global:converttoinvoice' => 'Converti in Fattura',
    'global:viewpdf' => 'Vedi PDF',
    'global:duplicate' => 'Duplica',
    'global:urltosend' => 'Questa è l\'URL per inviare:',  // does it means that URL is used to send some file or that you have to send the URL to someone?
    'global:copytoclipboard' => 'Copia negli Appunti',
    'global:quick_links' => 'Links Rapidi',
    'global:view_all' => 'Vedi Tutto',
    'global:deleted' => 'Cancellato',
    'global:add_more' => "Aggiungi Ulteriore",
    'global:upload_files' => "Upload Files",
    'global:optional_increment' => '<strong>Opzionale</strong> - sarà auto incrementato',
    'login:ahoy' => 'Ciao!',
    'login:readytodothis' => 'Pronto?',
    'login:sup' => 'Sup?',  //what does it means? I've checked with other translation and they all are different (including something chinese in the spanish one!)
    'global:actions' => 'Azioni',
    'global:select' => "--- Selezionare ---",
    'global:mark_as_unanswered' => 'Segna come Non Risposto',
    'global:mark_as_accepted' => 'Segna come  Accettato',
    'global:mark_as_rejected' => 'Segna come  Rifiutato',
    'global:reject_estimate' => 'Rifiuta Preventivo',
    'global:accept_estimate' => 'Accetta Preventivo',
    'global:estimate_rejected' => 'Preventivo Rifiutato',
    "global:estimate_accepted" => "Preventivo Accettato",
    'global:reject_proposal' => 'Rifiuta Proposta',
    'global:accept_proposal' => 'Accetta Proposta',
    'global:proposal_rejected' => 'Proposta Rifiutata',
    "global:proposal_accepted" => "Proposta Accettata",
    "global:client_area" => "Area Clienti",
    "global:admin" => "Admin",
    "global:all_settings" => "Tutte le Impostazioni",
    'global:viewable' => 'Visibile in Area Clienti',
    'global:not_viewable' => 'Non visibile in Area Clienti',
    'global:milestones' => "Milestones",
    /** Dashboard **/
    'dashboard:collected' => 'Incassato',   //is collected here for plural or singular?
    'dashboard:outstanding' => 'Scaduto',   //is overdue here for plural or singular?
    'dashboard:latest_activity' => 'Attività Recenti',
    'dashboard:these_are_your_upcoming_tasks' => "Questi sono i tuoi prossimi compiti, :1.",
    'dashboard:upcoming_tasks' => 'Prossime attività',
    /** End Dashboard **/
    /** Timesheets **/
    'global:timesheets' => 'Registro Orario',
    'timesheets:todays' => 'Oggi',
    'timesheets:all_users' => 'Tutti gli utenti',
    'timesheets:rounded_time' => 'Arrotondato al prossimo :1',
    'timesheets:there_are_no_time_entries' => "Non ci sono Registri Tempo da visualizzare per il periodo indicato.",
    /** END Timesheets **/
    /** Users **/
    // ==============================
    'login:forgotinstructions' => 'Prego inserire indirizzo email affinchè possiamo inviarle email per reimpostare la sua password.',
    'login:reset' => 'Reimposta Password',
    'login:username' => 'Username',
    'login:password' => 'Password',
    'login:changepassword' => 'Cambia Password',
    'login:email' => 'Indirizzo Email',
    'login:login' => 'Login',
    'login:logout' => 'Logout',
    'login:remember' => 'Ricordami',
    'login:forgot' => 'Password dimenticata?',
    'login:cancel' => '&laquo; Cancella',
    /** End Users **/
    /** User Groups **/
    'groups:edit_title' => 'Modifica Gruppo %s',
    'groups:add_title' => 'Aggiungi Gruppo Utenti',
    /** Clients **/
    'clients:title' => 'Tutti i Clienti',
    'clients:filter' => 'Filtro Clienti',
    'clients:add' => 'Aggiungi Cliente',
    'clients:removefilter' => 'Rimuovi Filtro',
    'clients:edit' => 'Modifica Cliente',
    'clients:noclienttitle' => 'Hai bisogno di inserire dei clienti!',
    'clients:noclientbody' => 'Così potrai inviare loro delle fatture. Aggiungerne uno adesso?',
    'clients:noclienttitlefilter' => 'Nessun Cliente risponde ai criteri',
    'clients:hasnoinvoicetitle' => 'Perfetto! Questo cliente è configurato!',
    'clients:hasnoinvoicebody' => 'Creiamo una fattura per loro ed iniziamo a riscuotere! Aggiungerne una adesso?',
    'clients:added' => 'Il Cliente è stato aggiunto!',
    'clients:edited' => 'Il Cliente è stato aggiornato!',
    'clients:deleted' => 'Il Cliente è stato eliminato!',
    'clients:does_not_exist' => 'Questo cliente non esiste!',
    'clients:health_check' => 'Stato di Salute',
    'clients:all' => 'Tutti',
    'clients:delete_title' => 'Cancellare questo Cliente?!?!',
    'clients:delete_message' => 'Sei sicuro di voler cancellare questo Cliente?<br />Questa operazione cancellerà anche tutte le relative fatture, i progetti e le proposte per questo cliente.',
    'clients:clientaction' => '&nbsp;',
    'clients:passphrase' => 'Password',
    'clients:bad_passphrase' => 'Password Errata.',
    'clients:total_clients' => 'Totale Clienti',
    'clients:support' => 'Supporto',
    'clients:support_rates' => 'Tariffe Supporto',
    'clients:edit_support_rates' => 'Imposta Tariffe',
    /** End Clients **/
    /** Contact Log **/
    'contact:contact' => 'Contatto',
    'contact:subject' => 'Oggetto',
    'contact:content' => 'Contenuto',
    'contact:method' => 'Metodo di Contatto',
    'contact:calling_title' => 'Chiamata Cliente ":1"',
    // 'contact:view_all'    =>  'View All',
    /** End Contact Log **/
    /** Invoices **/
    'invoices:markassent' => 'Segna come Inviato',
    'invoices:invoicedate' => 'Data Fattura',
    'invoices:file_name' => "Nome File",
    'invoices:date_created' => "Data Creazione",
    'invoices:size' => "Dimensioni",
    'invoices:files' => "Files",
    'invoices:sentbutunpaid' => 'Fatture inviate al Cliente ed ancora insolute',
    'invoices:duplicated' => 'Duplicata fattura #:1. Il nuovo numero di fattura è #:2.',
    'invoices:all' => 'Tutte le Fatture',
    'invoices:empty' => 'Ancora nessuna fattura.',
    'invoices:overdue' => 'Fatture Scadute',
    'invoices:tax_collected' => "Tasse Riscosse",
    'invoices:paid' => 'Fatture Pagate',
    'invoices:recurringinvoices' => 'Fatture Ricorrenti',
    'invoices:unsentinvoices' => 'Fatture non Inviate',
    'invoices:unpaid' => 'Fatture Insolute',
    'invoices:thisinvoicewaspaidon' => 'Questa fattura è stata pagata il giorno :1. Grazie!',
    'invoices:senton' => 'Inviata il giorno :1',
    'invoices:lastsenton' => 'Ultimo invio il giorno :1 alle :2',
    'invoices:paidon' => 'Pagata il giorno :1',
    'invoices:paidonsingle' => 'Pagata il',
    'invoices:thisinvoiceisunpaid' => "Questa fattura non è ancora stata pagata.",
    'invoices:noinvoicetitle' => 'Non ci sono ancora Fatture!',
    'invoices:noinvoicesforthefilteredclient' => "Non ci sono fatture per :1.",
    'invoices:noinvoicebody' => 'Dovresti creare una fattura adesso! <br /> I clienti amano le fatture!',
    'invoices:send_now_title' => 'Invia fattura adesso?',
    'invoices:send_now_body' => 'Riempi il moduo sottostante ed invieremo questa fattura per te!',
    'invoices:newinvoice' => 'Crea Fattura',
    'invoices:timequantity' => 'H./Q.tà',
    'invoices:ratewithcurrency' => 'Tariffa (:1)',
    'invoices:taxable' => 'Tassabile',
    'invoices:total' => 'Totale',
    'invoices:amount' => 'Importo',
    'invoices:due' => 'Scadenza',
    'invoices:subtotal' => 'Subtotale',
    'invoices:totaltax' => 'Totale Tasse',
    'invoices:filestodownload' => 'Files per Download',
    'invoices:added' => 'La Fattura è stata aggiunta!',
    'invoices:fileswillbeavailableafterpay' => 'Questi files saranno disponibili per il download dopo il saldo della fattura.',
    'invoices:no_payment_gateways_enabled' => 'Non è stato abilitato nessun gateway di pagamento, questo può rendere complicato essere pagati. Abilitali in <a href=":1">Impostazioni</a>',
    'invoices:invoicenumber' => 'Fattura #:1',
    'invoices:number' => 'Fattura #',
    'invoices:type' => 'Tipo Fattura',
    'invoices:is_recurring' => 'Ricorrente?',
    'invoices:is_paid' => 'Pagata?',
    'invoices:is_sent' => 'Inviata?',
    'invoices:date_entered' => 'Data Creazione',
    'invoices:delete_title' => 'Cancellare questa Fattura?',
    'items:select_time_entry' => 'Registrazione Tempo',
    'invoices:delete_message' => 'Sei sicuro di voler cancellare questa Fattura?',
    'invoices:create' => 'Crea Fattura',
    'invoices:edit' => 'Modifica Fattura',
    'invoices:amountrequired' => 'Il campo Importo è richiesto',
    'invoices:currencydoesnotexist' => 'Questa valuta non esiste.',
    'invoices:unique_id' => 'Unique ID',
    'invoices:willreoccurin' => 'Questa Fattura sarà nuovamente emessa il giorno :1.',
    'invoices:willbesentautomatically' => 'Il Cliente riceverà notifica via email di questa Fattura il giorno :1.',
    'invoices:clientlastnotifiedon' => 'Il Cliente è stato notificato via email di questa Fattura il giorno :1.',
    'invoices:simple' => 'Semplice',
    'invoices:simple_help' => 'Una Fattura Semplice non ha voci in elenco. Solamente un totale.',
    'invoices:detailed' => 'Dettagliata',
    'invoices:detailed_help' => 'Una Fattura Dettagliata permette di inserire in elenco voci di spesa multiple.',
    'invoices:estimate_help' => 'Un Preventivo è una previsione di spesa non fatturabile.',
    'invoices:unpaid_totalamount' => 'Insoluto / Importo Totale',
    'invoices:saveinvoice' => 'Salva Fattura',
    'invoices:deleted' => 'La fattura è stata cancellata!',
    'invoices:view' => 'Vedi Fattura',
    'invoices:is_viewable' => 'Mostrare in Area Cliente?',
    'invoices:no_invoices' => 'Non ci sono fatture.',
    'invoices:addedsuccess' => 'Hai aggiunto una Fattura per',
    'invoices:invoice' => 'fattura',
    'invoices:preview' => 'Anteprima Fattura',
    'invoices:editinvoice' => 'Modifica Fattura #:1',
    'invoices:messageupdated' => 'La Fattura è stata aggiornata!',
    'invoices:resend' => 'Reinvia Fattura',
    'invoices:client_viewed' => ':1 ha visualizzato <a href=":2">la fattura #:3</a> il :4',
    'invoices:client_paid' => ':1 ha pagato <a href=":2">la fattura #:3</a> il :4',
    'invoice:paid_amount' => 'Importo Pagato',
    /** End Invoices **/
    /** Estimates **/
    'estimates:attachedtoproposal' => 'Allegato alla Proposta #:1',
    'estimates:duplicated' => 'Duplicato Preventivo #:1. Il nuovo numero di Preventivo è #:2.',
    'estimates:alltitle' => 'Tutti i Preventivi',
    'estimates:attachingtoproposal' => 'Inserimento Preventivo nella Proposta, attendere per favore...',
    'estimates:delete_title' => 'Cancellare questo Preventivo?',
    'estimates:delete_message' => 'Sei sicuro vuoi cancellare questo preventivo?',
    'estimates:createnew' => 'Crea Preventivo',
    'estimates:generate_estimate' => 'Genera Preventivo',
    'estimates:converted' => 'Converti Preventivo #:1 in Progetto.',
    'estimates:converted_to_invoice' => 'Convertito Preventivo #:1 in Fattura.',
    'estimates:noestimatetitle' => 'Non hai preventivi',
    'estimates:noestimatesforthisclient' => 'Non hai preventivi per questo cliente.',
    'estimates:noestimatesforthefilteredclient' => "Non hai preventivi per :1.",
    'estimates:deleted' => 'Il Preventivo è stato cancellato!',
    'estimates:noestimatebody' => 'Dovresti effettuare un inserimento! Vuoi farne uno adesso?',
    'estimates:estimatenumber' => 'Preventivo #:1',
    'estimates:view' => 'Visualizza Preventivo',
    'estimates:no_estimates' => 'Non ci sono preventivi.',
    'estimates:addedsuccess' => 'Hai aggiunto un preventivo per',
    'estimates:estimate' => 'preventivo',
    'estimates:added' => 'Successo! Il preventivo è stato aggiunto.',
    'estimates:send_now_title' => 'Inviare preventivo adesso?',
    'estimates:send_now_body' => 'Riempi il modulo sottostante ed invieremo questo preventivo per te.',
    'estimates:send_now' => 'Invia Preventivo',
    'estimates:edit' => 'Modifica Preventivo',
    'estimates:preview' => 'Anteprima Preventivo',
    'estimates:editestimate' => 'Modifica preventivo #:1',
    'estimates:messageupdated' => 'Il preventivo è stato aggiornato!',
    'estimates:client_viewed' => ':1 visualizzato <a href=":2">preventivo #:3</a> il :4',
    'estimates:client_accepted' => ':1 accettato <a href=":2">preventivo #:3</a> il :4',
    'estimates:client_rejected' => ':1 respinto <a href=":2">preventivo #:3</a> il :4',
    'estimates:resend' => 'Reinvia Preventivo',
    'estimates:estimatedate' => 'Data Preventivo',
    /** End Estimates **/
    /** Projects **/
    'projects:status_id' => 'Stato Attività',
    'projects:projected' => 'Pianificato',   //what does °projected° refers to? In italian it can be translated both as feminine/masculine and singular/plural
    'projects:projected_hours' => 'Ore Pianificate',
    'projects:navigationitem' => 'Progetti',
    'projects:hours_worked' => 'Numero di ore lavorate',
    'projects:hours_worked_short' => 'Ore lavorate',
    'projects:alltitle' => 'Tutti i Progetti',
    'projects:totalprojects' => 'Totale Progetti',
    'projects:noprojecttitle' => 'Non ci sono progetti!',
    'projects:noprojecttext' => 'Vorresti aggiungerne uno adesso? ',
    'projects:add' => 'Crea Progetto',
    'projects:createfromtemplate' => 'Crea da Template',
    'projects:doesnotexist' => 'Il progetto a cui stai tentando di accedere non esiste.',
    'projects:edit' => 'Modifica Progetto',
    'projects:delete' => 'Cancella Progetto',
    'projects:project' => 'Progetto',
    'projects:new_project_from_estimate_without_number' => "Nuovo Progetto da Preventivo",
    'projects:new_project_from_estimate_with_number' => "Nuovo Progetto da Preventivo #:1",
    'projects:due_date' => 'Data Scadenza',
    'projects:is_completed' => 'Completato?',
    'projects:manage_project' => 'Gestisci Progetto',
    'projects:areyousuredeletetask' => 'Sei sicuro vuoi cancellare questa attività?',
    'projects:add_time' => 'Aggiungi Registrazione Tempo',
    'projects:add_hours' => 'Aggiungi Ore',
    'projects:generate_invoice' => 'Genera Fattura',
    'projects:no_projects' => 'Non ci sono progetti.',
    'projects:archive_proj' => 'Archivia Progetto',
    'projects:archive' => 'Vedi Archivio',
    'projects:active' => 'Progetto Attivo',
    'projects:archived' => 'Progetti Archiviati',
    'projects:noarchivedprojecttitle' => 'Non hai progetti arichiviati.',
    'projects:noarchivedprojecttext' => 'Puoi archiviare un progetto dalla pagina progetti ',
    'projects:allarchivedtitle' => 'Tutti i Progetti Archiviati',
    'projects:templatize' => 'Salva come Template',
    'projects:milestone_identifier' => "[Milestone: :1]",
    /** End Projects **/
    /** Milestones **/
    'milestones:add' => 'Aggiungi Milestone',
    'milestones:edit' => 'Modifica Milestone',
    'milestones:delete' => 'Cancella Milestone',
    'milestones:milestone' => 'Milestone',
    'milestones:assigned_user' => 'Utente Assegnato',
    'milestones:select_default' => '-- Nessuna milestone --',
    'milestones:no_milestone' => 'Attività senza Milestone',
    'milestones:add_success' => 'Milestone ":1" aggiunta con successo!',
    'milestones:edit_success' => 'Milestone ":1" modificata con successo!',
    'milestones:add_failed' => 'Milestone ":1" non può essere modificta.',
    'milestones:edit_failed' => 'Milestone ":1" non può essere aggiunta.',
    'milestones:are_you_sure_delete' => 'Sei sicuro vuoi cancellare questa milestone?',
    'milestones:delete_success' => 'Milestone ":1" cancellata con successo!',
    'milestones:does_not_exist' => 'Questa milestone non esiste.',
    'milestones:target_date' => 'Data obiettivo',
    'milestones:select_assignee_default' => 'Nessun Assegnatario',
    /** End Milestones **/
    /** Proposals **/
    'proposal:outline' => 'Schema Proposta',
    /** End Proposals **/
    /** Reminders **/
    'reminders:reminders' => 'Solleciti',
    'reminders:send' => 'Invia Sollecito',
    'reminders:success' => 'I Solleciti sono stati inviati!!',
    'reminders:remind' => 'Sollecita',
    'reminders:message' => 'Messaggi',
    'reminders:due' => 'Giorni',
    'reminders:details' => 'Dettagli',
    'reminders:log' => 'Registro',
    /** End Reminders **/
    /** Email Templates **/
    'emailtemplates:email_templates' => 'Templates Email',
    'emailtemplates:create_template' => 'Crea nuovo template',
    'emailtemplates:add' => 'Crea nuova email template',
    'emailtemplates:edit' => 'Modifica template email',
    'emailtemplates:manage' => 'Gestisci Templates',
    'emailtemplates:name' => 'Nome Email',
    'emailtemplates:subject' => 'Oggetto Email',
    'emailtemplates:days' => 'Intervallo di Giorni',
    'emailtemplates:type' => 'Tipo di Template',
    'emailtemplates:success' => 'Email template creato con successo',
    'emailtemplates:edited' => 'Email template modificato con successo',
    'emailtemplates:does_not_exist' => 'Email template non esistente',
    'emailtemplates:deleted' => 'Email template cancellato con successo',
    'emailtemplates:delete_title' => 'Cancella email template',
    'emailtemplates:delete_message' => 'Sei sicuro vuoi cancellare questo this email template?',
    /** End Email Templates **/
    /** Reports **/
    'reports:perclient' => 'per cliente',
    'reports:datefrom' => 'Da',
    'reports:allclients' => 'Tutti i Cienti',
    'reports:dateto' => 'To',
    'reports:byclient' => 'Cliente',
    'reports:view' => 'Vedi Report',
    'reports:show_all' => 'Mostra i Reports',
    'reports:paid_and_unpaid' => "Pagati e Insoluti",
    'reports:paid_vs_unpaid_over_time' => "Pagati vs. Insoluti nel periodo",
    'reports:per_client' => 'per Cliente',
    'reports:total_with_tax' => "Totale (con tasse)",
    'reports:total_without_tax' => "Totale (no tasse)",
    'reports:total_collected' => 'Totale Incassato',
    'reports:fees_paid' => 'Fees Pagate',   // what doess °fees° stands for here? Taxes? Invoices collected? work price per hour?
    'reports:total_amount' => 'Importo Totale',
    'reports:paid_amount' => "Importo Pagato",
    'reports:unpaid_amount' => "Importo Insoluto",
    'reports:client_name' => "Nome Cliente",
    'reports:nodata' => 'No :1.',
    /** End Reports **/
    /** Currencies **/
    'currencies:default' => '[Default] :1',
    'currencies:cad' => 'Canadian Dollar',
    'currencies:eur' => 'Euro',
    'currencies:usd' => 'U.S. Dollar',
    'currencies:gbp' => 'Sterlina Inglese',
    'currencies:hkd' => 'Hong Kong Dollar',
    'currencies:php' => 'Peso Filippino',
    'currencies:zar' => 'South Africa, Rand',
    /** End Currencies **/
    /** Proposals **/
    'proposals:duplicated' => 'Duplicato proposta #:1. Il numero della nuova proposta è #:2.',
    'proposals:usesectiontemplate' => 'Utilizza questa Sezione di Template',
    'proposals:showcontents' => 'Mostra Contenuti',
    'proposals:hidecontents' => 'Nascondi Contenuti',
    'proposals:deletepremadesection' => 'Cancella Sezione Template',
    'proposals:nopremadesections' => 'Non hai Sezioni di Templates salvate.',
    'proposals:newproposal' => 'Nuova Proposta',
    'proposals:number' => 'Proposta #',
    'proposals:all' => 'Tutte le Proposte',
    'proposals:noproposaltitle' => "Non ci sono proposte!",
    'proposals:noproposalbody' => "Dovresti creare una proposta adesso. Decisamente.",
    'proposals:client_viewed' => ':1 ha visualizzato la <a href=":2">proposta #:3</a> il :4',
    'proposals:client_accepted' => ':1 ha accettato la <a href=":2">proposta #:3</a> il :4',
    'proposals:client_rejected' => ':1 ha respinto la <a href=":2">proposta #:3</a> il :4',
    'proposals:rejected' => 'Respinta il :1',
    'proposals:accepted' => 'Respinta il :1',
    'proposals:lastviewed' => 'Ultima visualizzazione del Cliente il :1, alle :2.',
    'proposals:neverviewed' => 'Non visualizzata dal Cliente.',
    'proposals:noanswer' => 'Nessuna risposta',
    'proposals:createproposal' => 'Crea Proposta',
    'proposals:editproposal' => 'Modifica Proposta',
    'proposals:createdsuccessfully' => 'Proposta creata!',
    'proposals:sections' => 'Sezioni',
    'proposals:section' => 'Sezione',
    'proposals:createsection' => 'Aggiungi nuova Sezione',
    'proposals:createpage' => 'Aggiungi Pagina',
    'proposals:emptysection' => '(nessun titolo)',
    'proposals:emptycontents' => '(nessun contenuto)',
    'proposals:emptysubtitle' => '(nessun sottotitolo)',
    'proposals:for' => 'Proposta per:',
    'proposals:pagexofcount' => 'Pagina :1 di :2',
    'proposals:saving' => 'Salvataggio...',
    'proposals:save' => 'Salva Proposta',
    'proposals:savepremade' => 'Salva come sezione di template',
    'proposals:addestimate' => 'Aggiungi Preventivo',
    'proposals:saved' => 'Salvato!',
    'proposals:createandedit' => 'Prossimo: Modifica contenuti della proposta',
    'proposals:delete_message' => 'Sei sicuro vuoi cancellare questa proposta?',
    'proposals:createpremadesection' => 'Aggiungi da Sezione di Template',
    'proposals:selected_attachments' => 'Seleziona Preventivo',
    'proposals:attach_selected_estimate' => 'Allega Preventivo Selezionato',
    'proposals:proposal' => 'Proposta',
    'proposals:status' => 'Stato',
    'proposals:view' => 'Vedi Proposta',
    'proposals:estimate' => 'Preventivo',
    'proposals:no_proposals' => 'Non ci sono Proposte.',
    'proposals:proposal_title' => 'Titolo Proposta',
    'proposals:kitchennotice' => 'Nota: Le Proposte appariranno in :1 nel momento in cui il Ciente avrà cliccato nel link della proposta. Questo significa che puoi modificare ciò che desideri ed il Cliente non lo vedrà fino a che non vuoi che lo faccia.',
    /** End Proposals **/
    /** Tasks **/
    'tasks:task' => 'Attività',
    'tasks:edit_succeeded' => 'Attività Modificata con Successo.',
    'tasks:hours' => 'Ore',
    'tasks:due_date' => 'Data Termine',
    'tasks:is_completed' => 'Completata?',
    'tasks:timer' => 'Timer',
    'tasks:rate' => 'Tariffa',
    'tasks:default_rate' => 'Tariffa Standard',    // ** WARNING!! ** Since I was uncertain about °default rate° meaning I compared it with other translations, french and spanish both translated as °rate of default° and german as °standard rate* which are completely different things. I also translated it as standard rate(which seemed more correct to me referred to tasks), whatever it is there are two translations to correct!!!
    'tasks:entries' => 'Registri Tempo',
    'tasks:view_entries' => 'Vedi Registri',
    'tasks:edit_entry' => 'Modifica Registrazione Tempo',
    'tasks:create' => "Aggiungi Attività",
    'tasks:create_sub' => "Aggiungi Attività Secondaria",
    'tasks:task_parent' => "Attività Principale",
    'tasks:edit' => "Modifica Attività",
    'tasks:create_succeeded' => "L'attività è stata creata!",
    'tasks:no_task_title' => 'Hmm, non ci sono ancora attività...',
    'tasks:no_task' => "Nessuna Attività",
    'tasks:no_task_message' => 'Dovresti crearne qualcuna!',
    'tasks:is_viewable' => 'Visibile in area Cliente?',
    'tasks:no_milestones' => 'Attività senza milestones',
    'tasks:not_related_to_a_task' => "-- Non associato ad una attività --",
    'tasks:select_parent_default' => '-- Non ci sono attività principali --',
    'tasks:timers_running' => 'Timers Attivi',
    'tasks:task_completed_by' => ':1 ha completato <a href=":2">l\'attività :3</a> il :4',
    'tasks:discussion' => 'Discussione: ',
    'tasks:billed_hours' => "Ore Fatturate",
    'tasks:unbilled_hours' => "Ore Non Fatturate",
    /** Users **/
    'users:create_user' => 'Crea Utente',
    'users:confirm_delete_emphasised' => "Non è possibile tornare indietro!",
    /** Items **/
    'items:name' => 'Nome Voce',
    'items:description' => 'Descrizione Voce',
    'items:qty_hrs' => 'Qtà / Ore',
    'items:quantity' => 'Quantità',
    'items:rate' => 'Tariffa',
    'items:tax_rate' => 'Aliquota Fiscale',
    'items:cost' => 'Costo',
    'items:line_items' => 'Voci Contabili',  //Line Items can be translated in many ways, I need to know what it refers to to be more accurate
    'items:add' => 'Aggiungi Voce',
    'items:edit' => 'Modifica Voce',
    'items:noitemtitle' => 'Non hai ancora voci!',
    'items:noitembody' => 'Dovresti aggiungere delle voci adesso, rende la creazione di una fattura molto più facile!',
    'items:delete_title' => 'Cancellare questa voce?',
    'items:delete_message' => 'Sei sicuro vuoi cancellare la voce ":1"?',
    'items:type' => 'Tipo',
    'items:select_standard' => 'Standard',
    'items:select_expense' => 'Spese',
    'items:add_expense_to_project' => 'Aggiungi Spesa',
    'items:expenses' => 'Spese',
    /** END Items **/
    /** Expenses **/
    'expenses:expenses' => 'Spese',
    'expenses:add' => 'Aggiungi Spesa',
    'expenses:edit_expense' => 'Modifica Spesa',
    'expenses:delete' => 'Cancellare Spesa',
    'expenses:deleted' => 'Spesa Cancellata',
    'expenses:all' => 'Tutte le Spese',
    'expenses:amount' => 'Ammontare',
    'expenses:supplier' => 'Fornitore',
    'expenses:suppliers' => 'Fornitori',
    'expenses:category' => 'Categoria',
    'expenses:categories' => 'Categorie',
    'expenses:add_supplier' => 'Aggiungi Fornitore',
    'expenses:edit_supplier' => 'Modifica Fornitore',
    'expenses:add_category' => 'Aggiungi Categoria',
    'expenses:edit_category' => 'Modifica Categoria',
    'expenses:parent_category' => 'Categoria Principale',
    'expenses:filter' => 'Filtra Spese',
    'expenses:start_date' => 'Data Inizio',
    'expenses:end_date' => 'Data Termine',
    /** END Expenses **/
    /** Transactions **/
    'transactions:paymentcancelled' => 'Pagamento Cancellato',
    'transactions:extrapaymentcancelled' => 'Il tuo pagamento è stato cancellato.',
    'transactions:paymentreceived' => 'Pagamento Ricevuto!',
    'transactions:fee_applied' => 'Dal momento che :1 impone una tariffa di transazione, abbiamo aggiunto il :2% di sovrapprezzo.',
    'transactions:orderbeingprocessed' => 'Attendere prego, la tua disposizione è in fase di elaborazione, sarai reindirizzato al sito :1 .',
    'transactions:ifyouarenotredirected' => 'Se non verrai automaticamente reindirizzato a :1 entro 5 secondi...',
    'transactions:thankyouforyourpayment' => 'Grazie per il suo pagamento. Riceverà una ricevuta via email entro breve.',
    'transactions:ifyouhavefilesyouwillgetanemail' => 'Se ha dei files in attesa di essere consegnati riceverà un email con il link per poterli scaricare entro breve.',
    'transactions:ifyoudonotreceiveemail' => 'Se non riceverà un email entro un ora per favore contatti :1',
    /** End Transactions **/
    /** Timesheets **/
    'timesheet:taskname' => 'Nome Attività',
    'timesheet:starttime' => 'Start Time',
    'timesheet:endtime' => 'End Time',
    'timesheet:timeframe' => 'Periodo di Tempo',
    'timesheet:duration' => 'Durata',
    'timesheet:date' => 'Data',
    'timesheet:forproject' => 'Registro Orari per il Progetto ":1"',
    'timesheet:timesheet' => 'Registro Orari',
    'timesheet:for' => 'Registro Orari per:',
    'timesheet:totalbillable' => 'Ore Fatturabili Totali',
    'timesheet:view_pdf' => 'Vedi Registro Orari',
    'timesheet:user' => 'Utente',
    'timesheet:entries' => 'Voci',
    'timesheet:no_entries' => "Non ci sono registrazioni di tempo.",
    /** End Timesheets **/
    /** Support Tickets **/
    'tickets:all_tickets' => 'Tutti i Tickets',
    'tickets:support_tickets' => "Tickets di Supporto",
    'tickets:pending' => 'Sospeso',
    'tickets:open' => 'Aperto',
    'tickets:resolved' => 'Risolto',
    'tickets:closed' => 'Chiuso',
    'tickets:respond' => 'Rispondi al ticket',
    'tickets:ticket_options' => 'Opzioni Ticket',
    'tickets:attachment' => 'Allegato',
    'tickets:updated_status' => ':1 ha aggiornato lo stato del ticket in :2',
    'tickets:add_a_new_ticket' => "Aggiungi Nuovo Ticket",
    'tickets:create_a_new_ticket' => 'Crea Nuovo Ticket',
    'tickets:add_ticket' => 'Aggiungi Ticket',
    'tickets:assign_to_user' => 'Assegna ad Utente',
    'tickets:select_client' => 'Seleziona Cliente',
    'tickets:ticket_subject' => 'Oggetto del Ticket',
    'tickets:ticket_message' => 'Messaggio del Ticket',
    'tickets:ticket_priority' => 'Priorità del Ticket',
    'tickets:ticket_status' => 'Stato del Ticket',
    'tickets:no_priority' => '-- Nessuna Priorità --',
    'tickets:no_status' => '-- Nessuno Stato --',
    'tickets:no_posts' => "Nessun messaggio.",
    /** End Support Tickets **/
    /** Frontend **/
    'frontend:hithere' => 'Bentrovato!',
    'frontend:followthemaillinkdude' => 'Per poter vedere la sua fattura deve cliccare nel link completo che ha ricevuto in email. P.es. :1.',
    'frontend:contactadminforassistance' => 'Se ha bisogno di assistenza contatti :1 al :2',
    /** End Frontend **/
    /** Settings **/
    'settings:task_statuses' => "Stato delle Attività",
    'settings:ticket_statuses' => "Stato dei Tickets",
    'settings:ticket_priorities' => "Priorità dei Tickets",
    'settings:background_color' => "Background Color",
    'settings:text_color' => "Text Color",
    'settings:text_shadow' => "Text Shadow",
    'settings:box_shadow' => "Box Shadow",
    'settings:default_rate' => "Tariffa Standard",
    'settings:allowed_extensions' => 'Estensioni di cui è permesso upload',
    'settings:comma_separated' => 'separato da virgola',
    'settings:pdf_page_size' => 'Formato Pagine PDF',
    'settings:default_invoice_notes' => 'Note Predefinite in Fattura',
    'settings:default_invoice_title' => 'Titolo Predefinito della Fattura',
    'settings:default_invoice_due_date' => 'Scadenza Fattura Predefinita',
    'settings:autosave_proposals' => 'Salvataggio Automatico Proposte',
    'settings:default_invoice_due_date_explain' => 'giorni dalla creazione della fattura. Se non vuoi un termine predefinito lascia lo spazio vuoto.',
    'settings:testemailsettings' => 'Test Configurazione Email',
    'settings:include_remittance_slip' => 'Rimessa di Pagamento',
    'settings:include_remittance_slip_explain' => "Se selezionato, il PDF delle fatture incuderà una rimessa di pagamento.",
    'settings:items_per_page' => 'Voci per pagina',
    'settings:items_per_page_explain' => 'Numero di elementi (fatture/preventivi/proposte/progetti/attività) da mostrare in ciascuna pagina.',
    'settings:send_x_days_before' => '"invia X giorni prima" predefinito',
    'settings:file_to_import' => 'File da Importare',
    'settings:file_should_be_csv' => 'Pancake elaborerà automaticamente il file e ne importerà il contenuto. Se Pancake non riuscisse ad elaborare il file, ne riceverai notifica ed avrai l\'opzione di inviarci le informazioni al riguardo in modo da aiutarci a fare sì che Pancake possa elaborare il tuo file.',
    'settings:importnow' => 'Importa adesso!',
    'settings:whatimporting' => 'Cosa stai importando?',
    'settings:whatexporting' => 'Cosa stai esportando?',
    'settings:nouploadedimportfile' => 'Non hai caricato un file da importare.',
    'settings:import' => 'Importa',
    'settings:importedclients' => 'Importati :1 clienti con successo.',
    'settings:importedprojects' => "Importati :1 progetti con successo.",
    'settings:importedusers' => "Importati :1 utenti con successo.",
    'settings:importedinvoices' => 'Importati :1 fatture con successo.',
    'settings:importedtasks' => 'Importati :1 attività con successo.',
    'settings:importedestimates' => 'Importati :1 preventivi con successo.',
    'settings:importedtime_entries' => 'Importati :1 registri tempo con successo.',
    'settings:xwereduplicates' => ':1 erano dei duplicati e sono stati ignorati.',
    'settings:import_desc' => 'Importa dati in Pancake.',
    'settings:export' => 'Esporta',
    'settings:exportnow' => 'Esporta adesso!',
    'settings:importexport' => 'Importa / Esporta',
    'settings:removelogo' => 'Rimuovi Logo',
    'settings:wrong_license_key' => 'La license key inserita non è valida.',
    'settings:noopenssl' => 'Il tuo server PHP non ha OpenSSL configurato, ciò significa che non puoi utilizzare Gmail o Google Apps per inviare email. Per favore contatta il tuo servizio hosting ed informali che hai bisogno di OpenSSL.',
    'settings:logoremoved' => 'Logo rimosso con successo!',
    'settings:save' => 'Salva Impostazioni',
    'settings:logodimensions' => 'Il logo può essere caricato in qualsiasi misura e sarà ridimensionato automaticamente.',
    'settings:logoformatsallowed' => 'I formati accettati sono BMP, PNG, JPG (JPEG) e GIF.',
    'settings:ftp_user' => 'Utente FTP',
    'settings:ftp_pass' => 'Password FTP',
    'settings:ftp_path' => 'Percorso FTP',
    'settings:ftp_port' => 'Porta FTP',
    'settings:ftp_pasv' => 'Modalità Passiva?',
    'settings:nophpupdates' => "A causa della configurazione de tuo server, occorre inserire i dettagli di accesso FTP per permettere a Pancake di effettuare gli aggiornamenti. Questi dettagli sono utilizzati internamente da Pancake e non saranno mai comunicati a nessun altro.",
    'settings:ftp_host' => 'FTP Host',
    'settings:uptodate' => 'Pancake è aggiornato (:1)',
    'settings:newversionavailable' => 'C\'è una nuova versione di Pancake disponibile (:1)!',
    'settings:updatenow' => 'Aggiorna adesso!',
    'settings:checkforupdates' => "Controlla aggiornamenti",
    'settings:youneedtoconfigurefirst' => 'Il tuo Pancake non è ancora configurato per aggiornarsi automaticamente  Per favore inserisci i tuoi dettagli di accesso FTP nel modulo sottostante e premi "Salva Impostazioni".<br /> Pancake ti permetterà quindi di effettuare l\'aggiornamento.',
    'settings:general' => 'Generale',
    'settings:emails' => 'Emails',
    'settings:taxes' => 'Tasse',
    'settings:currencies' => 'Valute',
    'settings:branding' => 'Branding',
    'settings:payment_methods' => 'Pagamenti',
    'settings:feeds' => 'Feeds',
    'settings:api_keys' => 'API Keys',
    'settings:time_entry_times' => "Riepilogo Registrazioni Tempo",
    "settings:include_dates_and_times_in_line_items" => 'Includi date e orari nella descrizione voce di "Registrazione Tempo".',
    "settings:when_generating_invoice" => "Quando generi una fattura, utilizza una riga voce per",
    "settings:use_utf8_font" => "Utilizza caratteri UTF-8 nei PDFs",
    "settings:use_utf8_font_explanation" => "Utilizza se nei tuoi PDFs i caratteri sono difettosi.",
    "settings:pdf_attachments" => "Allegati PDF",
    "settings:pdf_attachments_explanation" => "Se selezionato, Pancake allegherà il corrispondente PDF alle email di fatture, preventivi o proposte.",
    'settings:site_name' => 'Nome Sito',
    'settings:language' => 'Lingua',
    'settings:timezone' => 'Timezone',
    'settings:currency' => 'Valuta',
    'settings:theme' => 'Tema Frontend',
    'settings:admin_theme' => 'Tema Admin',
    'settings:date_format' => 'Formato Data',
    'settings:time_format' => "Formato Tempo",
    'settings:task_time_interval' => 'Registrazione Tempo arrotondamento (Lascia vuoto per non arrotondare)',
    'settings:task_time_interval_description' => '(P.es. 00:30 or 0.5 - tutte le registrazioni orarie sono arrotondate alla più vicina mezz\'ora al momento della fatturazione.)',
    'settings:mailing_address' => 'Indirizzo Postale',
    'settings:default_subject' => 'Oggetto Predefinito',
    'settings:default_contents' => 'Messaggio Predefinito',
    'settings:new_estimate' => 'Nuovo Preventivo',
    'settings:new_invoice' => 'Nuova Fattura',
    'settings:new_proposal' => 'Nuova Proposta',
    'settings:paid_notification' => 'Notifiche Pagate',
    'settings:payment_receipt' => 'Ricevuta di Pagamento',
    'settings:new_ticket' => 'Nuovo Ticket',
    'settings:ticket_invoice' => "Nuova Fattura per Ticket",
    'settings:ticket_updated' => 'Ticket Aggiornato',
    'settings:ticket_status_updated' => 'Stato Ticket Aggiornato',
    'settings:logo' => 'Il tuo Logo',
    'settings:frontend_css' => 'CSS Personalizzato Frontend',
    'settings:backend_css' => 'CSS Personalizzato Backend',
    'settings:rss_password' => 'Password RSS',
    'settings:default_feeds' => 'Feeds Predefiniti',
    'settings:cron_job_feed' => 'Cron Job',
    'settings:feed_generator' => 'Generatore Feed',
    'settings:your_link' => 'Il tuo Link',
    'settings:bcc' => 'BCC',
    'settings:api_note' => 'Nome / Nota',
    'settings:api_key' => 'Key',
    'settings:tax_name' => 'Nome Tributo',
    'settings:tax_value' => 'Aliquota',
    'settings:add_tax' => 'Aggiungi nuovo tributo',
    'settings:currency_name' => 'Nome Valuta',
    'settings:currency_code' => 'Codice Valuta',
    'settings:exchange_rate' => 'Tasso di Cambio',
    'settings:add_currency' => 'Aggiungi Nuova Valuta',
    /** End Settings **/
    'update:ifyourenotsurecontactus' => "Se non sei sicuro su cosa fare, per favore <a href='https://www.pancakeapp.com/account/support/ticket/new'>apri un ticket di supporto <strong>GRATUITO</strong></a>.",
    'update:youmodified' => 'Hai modificato',
    'update:youdeleted' => 'Hai cancellato',
    'update:loadingpleasewait' => 'Caricamento, attendere prego...',
    'update:errordownloading' => 'Un aggiornamento di Pancake è disponibile, ma Pancake ha problemi a scaricarlo.',
    'update:herearestepstofix' => 'Ecco alcuni passi da seguire per provare a risolvere il problema:',
    'update:makesureuploadsiswritable' => 'Assicurati che la tua cartella uploads sia scrivibile (CHMOD 0777).',
    'update:deletepancakesystemupdate' => 'Cancellare la cartella pancake-update-system (all\'interno della cartella uploads), con tutto il suo contenuto.',
    'update:loadpancakeagain' => "Riavvia Pancake. Se l\'errore persiste, cambia il proprietario della cartella Pancake (chown) in modo che corrisponda all\'utente del webserver. Se non puoi, o non sai come farlo, per favore scrivi a support@pancakeapp.com, e ti aiuteremo.",
    'update:whatschanged' => "Novità in :1",
    'update:ftp_conn' => 'Pancake non può connettersi all\'host FTP.',
    'update:ftp_login' => 'Pancake non può effettuare l\'accesso FTP (Possibili username/password errati?).',
    'update:ftp_chdir' => 'Pancake non può  registrare il percorso FTP (il percorso probabilmente non esiste).',
    'update:ftp_no_uploads' => 'Pancake non può ottenere i permessi per caricare files via FTP.',
    'update:ftp_indexwrong' => 'Il percorso FTP inserito non è corretto. Dovresti indicare la directory principale di Pancake.',
    'update:ftp_indexnotfound' => 'Il percorso FTP inserito non è corretto. Dovresti indicare la directory principale di Pancake.',
    'update:update_conflict' => 'Hai modificato alcuni files dall\'ultimo aggiornamento. In modo da salvaguardare le tue personalizzazioni, questa è la lista dei files che hai modificato in conflitto con l\'ultimo aggiornamento.',
    'update:update_no_perms' => 'Pancake non ha i permessi necessari per l\'auto aggiornamento, non ha neppure accesso ad un account FTP dal quale potersi aggiornare. L\'aggiornamento non può continuare.',
    'update:review_files' => 'Si prega di rivedere questi file e farne il backup prima di procedere. Quando l\'aggiornamento sarà finito, dovrai nuovamente reintegrare le modifiche nei nuovi files. Per favore nota che non basta sostituire i file aggiornati con le copie modificate obsolete, poichè queste potrebbero danneggiare Pancake.',
    'update:internetissues' => "Pancake non è in grado di connettersi ad Internet.",
    'update:pancakeneedsinternet' => 'Affinchè Pancake funzioni correttamente, il server deve permettere di recuperare alcune informazioni da Internet (porta 80).',
    'update:maybefirewall' => "Sembra che il server stia bloccando l\'accesso a Internet di  Pancake. Potrebbe esserci un problema di firewall sul server. Si prega di contattare il tuo host per aiuto. Chiedete loro per consentire l'accesso a PHP :1.",
    'update:nointernetaccess' => 'Nessun Accesso Internet',
    'update:pancakeupdated' => 'Pancake è stato aggiornato da :1 a :2',
    /** Action Logger  **/
    /** End Action Logger **/
    /** Partial Payments **/
    'partial:totalamounttobepaid' => "Importo totale da pagare da parte del Cliente",
    'partial:amount' => 'Importo',
    'partial:add_payment' => 'Aggiungi Pagamento',
    'partial:dueon' => 'Scadenza il',
    'partial:paymentdetails' => 'Dettagli Pagamento',
    'partial:savepaymentdetails' => 'Salva i dettagli pagamento',
    'partial:proceedtopayment' => 'Proceda al pagamento',
    'partial:topaynowgoto' => 'Per pagare adesso, per favore vada a :1',
    'partial:pay_part_x_now' => "Paga la parte #:1 della tua fattura adesso",
    'partial:dueondate' => 'scadenza il :1',
    'partial:paymentmethod' => 'Metodo di Pagamento',
    'partial:paymentdate' => 'Data Pagamento',
    'partial:paymentstatus' => 'Stato Pagamento',
    'partial:transactionid' => 'ID Transazione',
    'partial:markaspaid' => 'Contrassegna come Pagato',
    'partial:transactionfee' => 'Commissione Transazione',
    /** End Partial Payments **/
    /** Payment Gateways **/
    'paypal:clickhere' => 'Clicca qui per procedere',
    'authorize:transaction_key' => 'Key Transazione',
    'paypal:email' => 'Email PayPal',
    'paypal:fee' => 'Commissione PayPal (%)',
    'paypalpro:paypalpro' => 'PayPal Payments Pro (BETA)',
    'paypalpro:viacreditcard' => 'Paga con Carta di Credito',
    'cash:cash' => 'Contante',
    'check:check' => 'Assegno',
    'moneyorder:moneyorder' => 'Vaglia',
    'creditcard:creditcard' => 'Carta di Credito',
    'banktransfer:banktransfer' => 'Bonifico Bancario',
    'gateways:errorupdating' => 'Si è verificato un errore durante l\'aggiornamento delle impostazioni dei tuoi metodi di pagamento.  Per favore contatta il supporto.',
    'gateways:paymentmethods' => 'Metodi di pagamento',
    'gateways:selectpaymentmethod' => 'Seleziona Metodi di pagamento',
    'gateways:nogatewayused' => 'Nessun metodo di pagamento indicato: Pagamento non effettuato',
    'gateways:completed' => 'Completato',
    'gateways:refunded' => 'Rimborsato',
    'gateways:unpaid' => 'Insoluto',
    'gateways:paymentrejected' => ':1 Pagamento Respinto',
    'gateways:pending' => 'In attesa',
    'gateways:returntowebsite' => 'Ritorna a :1',
    'gateways:cc_type' => 'Tipo di Carta di Credito',
    'gateways:cc_number' => 'Numero Carta di Credito',
    'gateways:cc_exp' => 'Data di scadenza',
    'gateways:cc_cardholder' => 'Nome sulla carta',
    'gateways:cc_code' => 'CVV Code',
    'gateways:payment_details' => 'Dettagli Pagamento',
    'gateways:api_signature' => 'Firma API',
    'gateways:api_password' => 'Password API',
    'gateways:api_username' => 'Username API',
    /** End Payment Gateways **/
    /** Kitchen Area **/
    'kitchen:edit_comment' => 'Modifica Commento',
    'kitchen:add_a_comment' => "Aggiungi commento",
    'kitchen:kitchen_name' => 'Accesso Area Cliente',
    'kitchen:pleaselogin' => 'Inserisci la tua password per accedere all\'account',
    'kitchen:nocomments' => 'Non ci sono ancora commenti.',
    'kitchen:comment' => 'Commento',
    'kitchen:comments' => 'Commenti',
    'kitchen:comments_x' => 'Commenti (:1)',
    'kitchen:file' => 'File',
    'kitchen:submitcomment' => 'Aggiungi comment',
    'kitchen:attachment' => 'Allegato',
    'kitchen:saidon' => 'ha detto il :1, a :2',
    'kitchen:subjectinvoice' => 'Nuovo commento per Fattura #',
    'kitchen:subjectestimate' => 'Nuovo commento per Preventivo #',
    'kitchen:subjectproject' => 'Nuovo commento per Progetto:',
    'kitchen:subjecttask' => 'Nuovo commento per Attività:',
    'kitchen:subjectproposal' => 'Nuovo commento per Proposta:',
    'kitchen:backtodashboard' => 'Torna alla Dashboard',
    'kitchen:client_welcome' => 'Area di accesso Cliente per:',
    'kitchen:urltosend' => 'URL accesso Cliente',
    'kitchen:nopassphrase' => 'Attualmente la "password" Cliente non è impostata, questo significa che basta accedere a tale URL per visualizzare l\'area Cliente. Se preferisci renderla più sicura con una semplice password si prega di modificare la scheda Cliente e di impostarne una.',
    'kitchen:passphraseset' => 'Questo Cliente ha una password impostata',
    'kitchen:passphrase' => 'Password',
    'kitchen:description' => 'Questo è l\'URL da inviare al vostro Cliente per consentirgli di accedere all\'area Cliente, dove può controllare i dati, come i progetti e le fatture, che avete reso visualizzabili.',
    'kitchen:people_in_discussion' => 'Persone in chat',
    'kitchen:latest_invoice' => 'Ultima Fattura',
    'kitchen:unpaid_balance' => 'Saldo Insoluto: :1',
    'kitchen:total_paid_to_date' => 'Totale Pagato alla Data: :1',
    /** END Kitchen Area **/
    'store:store' => 'Negozio',
    'store:buy' => "Acquista ($:1)",
    'store:update' => "Aggiorna",
    'store:install' => "Installa",
    'store:settings' => "Impostazioni",
    'store:already_bought' => "Hai già acquistato questo componente!",
    'store:installed_successfully' => "Hai installato :1 :2 con successo.",
    'store:plugin' => "Plugin",
    'store:payment_gateway' => "Gateway di Pagamento",
    'store:frontend_theme' => "Tema Frontend",
    'store:backend_theme' => "Tema Backend",
    'store:unknown' => "Sconosciuto",
    'store:updatestoreitems' => "Aggiorna Oggetti Negozio",
    'store:download_free' => "Download (GRATUITO)",
    'store:error1000' => "Il tuo token di autorizzazione non è più valido. Occorre inserire nuovamente i dati di pagamento in pancakeapp.com .",
    'store:error1001' => "Hai già acquistato questo oggetto del negozio!",
    'store:error1002' => "Si è verificato un problema durante il tentativo di pagamento con carta di credito. Riprovare più tardi.",
    'store:error1003' => "Hai effettuato una richiesta non valida.",
    'email_templates:new_invoice' => 'Nuova Fattura',
    'email_templates:new_estimate' => 'Nuovo Preventivo',
    'email_templates:new_proposal' => 'Nuova Proposta',
    'email_templates:invoice_payment_notification_for_admin' => 'Notifica di pagamento (inviato ad admin)',
    'email_templates:invoice_payment_notification_for_client' => 'Notifica di ricevuto pagamento (inviato al Cliente)',
    'email_templates:new_ticket' => 'Nuovo Ticket',
    'email_templates:new_ticket_invoice' => 'Nuova Fattura per Ticket',
    'email_templates:ticket_updated' => 'Notifica Aggiornamento Ticket',
    'email_templates:ticket_status_updated' => 'Notifica Aggiornamento Stato del Ticket',
    'email_templates:assigned_to_task' => "Notifica Assegnazione Attività",
    'email_templates:assigned_to_milestone' => "Notifica Assegnazione Milestone",
    'email_templates:new_comment' => "Notifica Nuovo Commento",
    'global:timer_app' => "Pancake Timer App",
    'global:there_is_no_activity' => "Non ci sono attività del team da mostrare.",
    'global:there_are_no_tasks_assigned_to_you' => "Non ci sono  attività a te assegnate.",
    /** Dashboard **/
    /** END Dashboard **/
    # v4.0.5
    # Begin v4.1.2 changes
    'invoices:converted_to_estimate' => "Converti Fattura #:1 in Preventivo.",
    'global:converttoestimate' => 'Converti in Preventivo',
    # End v4.1.2 changes
    # Begin v4.1.3 changes
    'tickets:view_archived' => "Vedi Tickets Archiviati",
    'tickets:view_unarchived' => "Vedi Tickets Attivi",
    'tickets:archiving_ticket' => "Archiviazione ticket",
    'tickets:unarchiving_ticket' => "Disarchiviazione ticket",
    "tickets:unknown_error_ticket_not_altered" => "Si è verificato un errore sconosciuto. Il ticket non è stato alterato.",
    # End v4.1.3 changes
    # Begin v4.1.4 changes
    "tasks:starting_timer" => "Avvio timer",
    "tasks:stopping_timer" => "Interruzione timer",
    "global:all_comments" => "Tutti i Commenti",
    "dashboard:view_all_comments" => "Vedi Tutti i Commenti",
    "dashboard:latest_comments" => "Commenti Recenti",
    "dashboard:written_by" => "Scritto da :1 il :2",
    "dashboard:client_activity" => "Attività Cliente",
    "dashboard:view_all_client_activity" => "Vedi tutte Attività del Cliente",
    "dashboard:view_all_team_activity" => "Vedi tutte Attività del Team",
    "dashboard:my_tasks" => "Le mie Attività",
    "dashboard:view_all_my_tasks" => "Vedi tutte le mie attività",
    "dashboard:what_the_team_is_working_on" => "A cosa sta lavorando il team.",
    # End v4.1.4 changes
    # Begin v4.1.6 changes
    "global:save_milestone" => "Salva Milestone",
    "global:save_task" => "Salva Attività",
    "global:private_comment" => "Questo commento è privato. Il tuo cliente non lo vedrà.",
    "global:clients_cant_see_private" => "I Clienti non possono vedere i commenti privati.",
    "global:is_private" => "Privato?",
    # End v4.1.6 changes
    # Begin v4.1.7 changes
    "tickets:disable_client" => "-- Disabilita Tickets di Supporto  --",
    # End v4.1.7 changes
    # Begin v4.1.8 changes
    "global:css" => "CSS personalizzato",
    "global:js" => "JavaScript personalizzato",
    "global:js_explanation" => "È possibile utilizzare jQuery se desiderato. Il tuo codice verrà aggiunto subito prima di &lt;/body&gt;.",
    "settings:frontend_js" => "Frontend JavaScript Personalizzato",
    "settings:backend_js" => "Backend JavaScript Personalizzato",
    # End v4.1.8 changes
    # Begin v4.1.9 changes
    "proposals:estimate_number_and_amount" => "Preventivo #:1 (:2)",
    # End v4.1.9 changes
    # Begin v4.1.10 changes
    "clients:delete" => "Cancellare Cliente",
    # End v4.1.10 changes
    # Begin v4.1.11 changes
    "global:nolongerexists" => "[NON ESISTE  PIÚ]",
    "global:billed_amount" => "Importo Fatturato",
    "global:unbilled_amount" => "Importo Non Fatturato",
    "global:is_billed" => "Fatturato?",
    # End v4.1.11 changes
    # Begin v4.1.14 changes
    "settings:year_start" => "Data inizio Anno Fiscale",
    "dashboard:since_explanation" => "Dal :1",
    # End v4.1.14 changes
    # Begin v4.1.15 changes
    "export:invoices_csv" => "Fatture (CSV)",
    # End v4.1.15 changes
    # Begin v4.1.17 changes
    "projects:createdtemplate" => "Template di progetto creato. È ora possibile creare progetti basati su questo modello.",
    "projects:delete_template" => "Cancellare Template",
    "projects:deleted_template" => "Template cancellato con successo.",
    # End v4.1.17 changes
    # Begin v4.1.19 changes
    "export:expenses_csv" => "Spese (CSV)",
    "export:clients_csv" => "Clienti (CSV)",
    "projects:expense_date" => "Data Spesa",
    # End v4.1.19 changes
    # Begin v4.1.20 changes
    "clients:can_create_support_tickets" => "Consentire al Cliente di creare tickets di supporto?",
    "tickets:submit_new" => "Invia un Ticket",
    "global:cancel" => "Cancella",
    "global:timers" => "Timers",
    "global:more" => "Altro",
    # End v4.1.20 changes
    # Begin v4.1.23 changes
    "global:search" => "Cerca",
    "authorize:api_login_id" => "API Login ID",
    "authorize:api_login_id_description" => "Puoi trovarlo in Authorize.net, sotto Account > API Login ID and Transaction Key.",
    "authorize:md5_hash" => "MD5-Hash",
    "authorize:md5_hash_description" => "Per default, questa è la tua API Login ID. Puoi cambiarla in Authorize.net, sotto Account > MD5-Hash. Se vedi 'Hash Value Set: No', lascia il campo vuoto.",
    "transactions:paymentfailed" => "Pagamento non eseguito",
    "transactions:extrapaymentfailed" => "Un problema sconosciuto si è verificato durante il tentativo di elaborare il pagamento. Si prega di contattare :1 a :2 per assistenza.",
    # End v4.1.23 changes
    # Begin v4.1.24 changes
    "projects:tracked" => "Tracciato",
    "invoices:partially_paid" => "Parzialmente",
    # End v4.1.24 changes
    # Begin v4.1.27 changes
    "global:projects_ommitted" => ":1 progetti non visualizzati",
    "global:tasks_ommitted" => ":1 attività non visualizzate",
    # End v4.1.27 changes
    # Begin v4.1.28 changes
    "login:username_email" => "Username / Email",
    # End v4.1.28 changes
    # Begin v4.1.31 changes
    "settings:when_new_updates_are_available" => "Quando sono disponibili nuovi aggiornamenti",
    "settings:dont_install_just_notify_me" => "Non installare, invia solo notifica",
    "settings:install_automatically" => "Installa automaticamente",
    "settings:loading_update_details" => "Elaborazione dettagli aggiornaremento ... Questa operazione potrebbe richiedere un minuto o due. Sentitevi liberi di effettuare un refresh in qualsiasi momento.",
    "settings:will_have_to_overwrite_single_file" => "Pancake dovrà sovrascrivere 1 file che è stato modificato manualmente!",
    "settings:will_have_to_overwrite_multiple_files" => "Pancake dovrà sovrascrivere :1 files che sono stati modificati manualmente!",
    "settings:checking_for_updates" => "Controllo degli aggiornamenti, attendere prego. Questa pagina farà refresh automaticamente.",
    "settings:updating_please_wait" => "Aggiornamento in corso, attendere prego. Questa pagina verrà ricaricata quando l'aggiornamento sarà terminato.",
    "settings:description" => "Salva le impostazioni aggiornate prima di cambiare sched o lasciare la pagina.",
    "settings:business_identities" => "Identità Business",
    "settings:business_name" => "Nome Business",
    "settings:new_business" => "Nuovo Business",
    "settings:business_identity" => "Identità Business",
    "settings:business_identity_explanation" => "Il vostro cliente vedrà questa identità aziendale su tutti i documenti: e-mail, PDF e pagine.",
    # End v4.1.31 changes
    # Begin v4.1.33 changes
    "settings:have_been_updated" => 'Le impostazioni sono state aggiornate.',
    "tasks:all" => "Tutte le Attività",
    "projects:progress" => "Progresso",
    "expenses:name" => "Nome Spesa",
    "tasks:add_hours_to" => "Aggiungi Ore a :1",
    "global:today" => "Oggi",
    "global:yesterday" => "Ieri",
    "global:other" => "Altro",
    "global:now" => "Adesso",
    "timesheet:view_for_clients" => "Vedi Registri Orari (per Clienti)",
    "global:not_billed_yet" => "Non ancora fatturati.",
    "tasks:total_logged_time" => "Tempo totale registrato",
    "global:biweekly" => "Bisettimanale",
    # End v4.1.33 changes
    # Begin v4.2 changes
    'settings:default_task_due_date' => 'Termine predefinito Attività',
    'settings:default_task_due_date_explain' => "giorni dopo creazione attività . Se non si desidera una data predefinita, lasciare il campo vuoto.",
    # End v4.2 changes
    # Note: 4.2.x brought changes to the language file that weren't appended to the end of the file.
    # If you're updating your translation, make sure to check out a diff of the language file, instead of relying on just checking the bottom of the file.
    # Begin v4.2.4 changes
    "expenses:sort_or_filter" => "Ordina / Filtra Spese",
    "expenses:show" => "Mostra Spese",
    "global:sort_by" => "Ordina per",
    "global:sort_order" => "Ordinamento",
    "global:asc" => "Ascendente (A-Z)",
    "global:desc" => "Discendente (Z-A)",
    # End v4.2.4 changes
    # Begin v4.3.0 changes
    "settings:tax_compound" => "Composto?",
    "settings:no_tax" => "Senza tasse",
    "settings:default_taxes" => "Tasse predefinite",
    "global:and" => "e",
    "global:tax" => "Tasse",
    # End v4.3.0 changes
    # Begin v4.3.6 changes
    "global:youarenotallowed" => "Non è consentito per accedere a questa pagina.",
    # End v4.3.6 changes
    # Begin v4.3.7 changes
    'settings:notify_email' => 'Email Supporto',
    'settings:billing_email' => 'Email Fatturazione',
    'settings:brand_name' => 'Nome Brand',
    'settings:admin_name' => 'Nome Admin',
    'settings:brand_name_explanation' => 'Questo è il nome che si desidera i clienti vedano. Verrà visualizzato ovunque tranne nelle fatture.',
    'settings:business_name_explanation' => 'Questo è il nome legale del vostro business . Verrà visualizzato sulle tue fatture.',
    'settings:admin_name_explanation' => 'Per impostazione predefinita, apparirà nella parte inferiore della tua e-mail ai clienti.',
    'settings:billing_email_explanation' => 'Questo è l\'indirizzo "Da" utilizzato per le email di Fatture, Preventivi e Proposte .',
    'settings:notify_email_explanation' => 'Questo è l\'indirizzo "Da" utilizzato per notifiche di commento e tickets di supporto.',
    'settings:show_name_along_with_logo' => 'Mostrare il nome aziendale accanto al vostro logo?',
    'dashboard:your_projects' => 'I tuoi Progetti',
    'dashboard:today' => 'Oggi',
    'dashboard:team_activity' => 'Aggiornamenti',
    'dashboard:snapshot' => 'Istantanea',
    'invoices:frequency' => 'Frequenza',
    'invoices:auto_send' => 'Invio Automatico?',
    'invoices:send' => 'Invia',
    'invoices:days_before_invoice_is_due' => 'giorni prima del termine fattura',
    'invoices:cannot_change_recurrences' => 'Non è possibile modificare le impostazioni di ricorrenza di una fattura che è la ricorrenza di un\'altra fattura.',
    # End v4.3.7 changes
    # Begin v4.3.8 changes
    'email_templates:client_area_details' => 'Dettagli Cliente Area',
    'settings:always_https' => 'Forzare HTTPS?',
    'settings:always_https_explanation' => 'Farà eseguire Pancake sempre tramite HTTPS. Utilizzare solo se si dispone di un certificato SSL installato ed è possibile accedere a Pancake tramite HTTPS.',
    'settings:remittance_slip' => 'Rimessa di Pagamento',
    'invoices:mail_to' => 'Spedisci a',
    'clients:send_client_area_email' => 'Invia Dettagli Area Cliente',
    'clients:you_cannot_send' => 'Non è possibile inviare a questo Cliente i Dettagli di accesso della sua Area via email perché non ha un indirizzo email.',
    # End v4.3.8 changes
    # Begin v4.4.0 changes
    'invoices:discount' => 'Sconto',
    'invoices:discount_explain' => 'Aggiungere % per le percentuali.',
    'invoices:addedconf' => 'Hai aggiunto la fattura # <strong>:1</strong>, totalizzando <strong>:2</strong> (:3 con tasse) per :4:5.',
    'estimates:addedconf' => 'Hai aggiunto il Preventivo # <strong>:1</strong>, totalizzando <strong>:2</strong> (:3 con tasse) per :4:5.',
    'credit_notes:edit_credit_note' => 'Modifica Nota di Credito #:1',
    'credit_notes:create_credit_note' => 'Crea Nota di Credito',
    'global:credit_notes' => 'Note di Credito',
    'global:credit_note' => 'Nota di Credito',
    'credit_notes:alltitle' => 'Tutte le Note di Credito',
    'credit_notes:nocredit_notesforthefilteredclient' => 'Non hai Note di Credito per :1.',
    'credit_notes:no_credit_notes' => 'Non hai Note di Credito.',
    'credit_notes:create' => 'Crea Nota di Credito',
    'credit_notes:no_credit_notes_body' => 'Desideri crearne una adesso?',  // I have noticed by chance that french translation for this item is wrong. As soon as I understand gitub I'll edit it
    'credit_notes:edit' => 'Modifica Nota di Credito',
    'credit_notes:credit_note_number' => 'Nota di Credito #:1',
    'credit_notes:credit_note_date' => 'Data Nota di Credito',
    'credit_notes:delete_title' => 'Cancellare questa Nota di Credito?',
    'credit_notes:delete_message' => 'Sei sicuro vuoi cancellare questa Nota di Credito?',
    'credit_notes:addedconf' => 'Hai aggiunto la Nota di Credito # <strong>:1</strong>, totalizzando <strong>:2</strong> (:3 con tasse) per :4:5.',
    'credit_notes:send_now_title' => 'Inviare Nota di Credito addesso?',
    'credit_notes:send_now_body' => "Compila il modulo sottostante e consegneremo questa nota di credito per te.",
    'email_templates:new_credit_note' => 'Nuova Nota di Credito',
    'credit_notes:send_now' => 'Invia Nota di Credito',
    'credit_notes:preview' => 'Anteprima Nota di Credito',
    'credit_notes:duplicated' => "Duplicata Nota di Credito #:1. Il numero della nuova Nota di Credito è #:2.",
    'credit_notes:client_viewed' => ":1 ha visualizzato <a href=':2'>Nota di Credito #:3</a> il :4",
    'invoices:make_bulk_payment' => 'Esegui Pagamenti Multipli',
    'global:success' => 'Successo!',
    'clients:view' => 'Vedi Cliente',
    'invoices:store_bulk_payment' => 'Salva Pagamenti Multipli',
    'invoices:x_invoices' => ':1 fatture',
    'invoices:amount_to_pay' => 'Importo contrassegnato come Pagato',
    'invoices:bulk_payment_added' => "I pagamenti sono stati aggiunti con successo.",
    'clients:credit_balance_currently' => "Saldo credito (attualmente :1)",
    'clients:has_no_unpaid_invoices' => ":1 non ha fatture insolute.",
    'invoices:send_payment_notification' => "Inviare email di notifica di pagamento al cliente?",
    'invoices:send_bulk_payment_notification' => "Inviare notifica di ricevuto pagamento al Cliente?",
    'invoices:specify_bulk_payment_details' => "Specificare il dettagli dei pagamenti del cliente e selezionare a quali fatture si riferiscono i pagamenti.",
    'global:credit_balance' => "Saldo",
    # End v4.4.0 changes
    # Begin v4.4.1 changes
    'credit_notes:view' => 'Vedi Nota di Credito',
    # End v4.4.1 changes
    # Begin v4.4.3 changes
    'tickets:ticket_number' => "Ticket #:1",
    'settings:ticket_status_for_sending_invoice' => "Stato del Ticket per la fatturazione",
    'settings:ticket_status_for_sending_invoice_description' => "Quando un ticket a pagamento viene aggiornato nello stato, una fattura verrà automaticamente generata e inviata al Cliente.",
    'settings:never_send_ticket_invoices_automatically' => "-- Non inviare automaticamente le fatture dei tickets --",
    # End v4.4.3 changes
    # Begin v4.4.6 changes
    'expenses:added' => "La spesa è stata inserita correttamente.",
    # End v4.4.6 changes
    # Begin v4.4.9 changes
    'global:error_submitting_ajax' => "Si è verificato un errore sconosciuto durante il tentativo di inviare questo modulo. Per favore riprova più tardi. Se l'errore persiste, si prega di avviare una richiesta di assistenza gratuita presso pancakeapp.com.",
    'store:error1004' => "Si è verificato un errore sconosciuto durante il tentativo di acquistare questo oggetto. Per favore riprova più tardi. Se l'errore persiste, si prega di avviare una richiesta di assistenza gratuita presso pancakeapp.com.",
    # End v4.4.9 changes
    # Begin v4.5.0 changes
    'invoices:pancake_will_automatically_change_is_viewable' => "Questo verrà automaticamente cambiato in 'Sì' quando invierai via email la fattura al Cliente.",
    "global:incorrect_login" => "La combinazione username / password che hai inserito non è valido.",
    # End v4.5.0 changes
    # Begin v4.5.3 changes
    'contact:title' => 'Cronologia Contatto',
    # End v4.5.3 changes
    # Begin v4.5.5 changes
    'settings:hide_tax_column' => "Nascondere Colonna Tasse?",
    'settings:hide_tax_column_explanation' => "Questa opzione nasconderà la colonna imposta nelle fatture che non hanno dati fiscali.",
    'tickets:not_yet_generated' => "Fattura non ancora generato",
    'tickets:invoice_will_be_generated' => "Una :1 fattura per questo ticket sarà generata quando lo stato del ticket è modificato in \":2\".",
    'global:accepted' => "Approvato",
    'global:rejected' => "Respinto",
    'global:unanswered' => "Senza Risposta",
    'estimates:accepted' => "Preventivi Approvati",
    'estimates:rejected' => "Preventivi Respinti",
    'estimates:unanswered' => "Preventivi Senza Risposta",
    'emailtemplates:content' => "Contenuto Email",
    'global:every_six_months' => 'Biannuale (due volte l\'anno)',
    'global:biyearly' => 'Biennale (ogni due anni)',
    'global:triennially' => "Trienniale",
    # End v4.5.5 changes
    # Begin v4.5.6 changes
    'settings:automaticallybccclientemail' => 'Invia automaticamente una copia di tutti i messaggi di posta elettronica del Cliente al tuo indirizzo email di supporto principale.',
    # End v4.5.6 changes
    # Begin v4.5.7 changes
    'invoices:send_to_client' => "Invia Fattura via Email",
    'estimates:send_to_client' => "Invia Preventivo via Email",
    'global:beforeunload' => "Stai per uscire da questa pagina. In tal caso, tutti i dati inseriti finora saranno persi. Sicuro che di voler uscire dalla pagina?",
    # End v4.5.7 changes
    # Begin v4.5.8 changes
    'global:appendtoproject' => 'Converti in attività per ":1"',
    'estimates:appended' => 'Convertito Preventivo #:1 in attività per ":2".',
    # End v4.5.8 changes
    # Begin v4.6.0 changes
    'items:percentage_discount' => "Sconto (%)",
    'items:fixed_discount' => "Sconto (:1)",
    'invoices:discount_percentage' => "Sconto (:1%)",
    'invoices:sub_total_after_discounts' => "Subtotale (dopo Sconti)",
    'settings:tax_reg' => 'Codice Fiscale / Partita IVA',
    'clients:tax_registration_number' => ':1 CF / P.IVA',
    'clients:add_custom_field' => "Aggiungi altro campo personalizzato",
    'clients:tax_numbers' => 'Codice Fiscale / Partita IVA del Cliente',
    'clients:custom_fields' => "Campo personalizzato",
    'expenses:category_added' => "La categoria di spesa è stata creata con successo.",
    'clients:update_balance' => "Aggiorna Saldo",
    'clients:balance_updated' => "Il saldo del cliente è stato aggiornato con successo.",
    'clients:what_do_you_want_to_do' => "Che cosa vuoi fare",
    'clients:save_balance_alteration' => "Salva variazione saldo",
    'clients:no_amount_specified' => "Non è stato specificato un importo.",
    'expenses:attach_receipt' => "Allega Ricevuta (Dimensioni massime: :1)",
    'expenses:no_project_business_expense' => "Spesa Aziendale (Fuori Progetto)",
    'expenses:expense_date' => "Data",
    'expenses:receipt' => "Ricevuta",
    'expenses:no_receipt' => "Nessuna Ricevuta",
    # End v4.6.0 changes
    # Begin v4.6.3 changes
    'expenses:edited' => "La spesa è stata modificata con successo.",
    'expenses:expense_receipts' => "Ricevute di Spesa",
    # End v4.6.3 changes
    # Begin v4.6.7 changes
    'reports:payments' => "Pagamenti",
    'reports:verb_created' => "Creato",
    'reports:verb_paid' => "Pagato",
    'reports:verb_from_to' => ":1 da :2 ao :3",
    # Deleted "reports:selection_explanation_accrual"
    # Deleted "reports:selection_explanation_cash"
    # Deleted "settings:accounting_type"
    # Deleted "settings:accrual"
    # Deleted "settings:cash"
    # End v4.6.7 changes
    # Begin v4.6.8 changes
    'reports:amount_paid' => "Importo Pagamento",
    # End v4.6.8 changes
    # Begin v4.6.9 changes
    'dashboard:upcoming_invoices' => 'Fatture Pendenti',
    'dashboard:there_are_no_upcoming_invoices' => "Non ci sono fatture pendenti da mostrare.",
    # End v4.6.9 changes
    # Begin v4.7.0 changes
    "error:cannot_send_error_details" => "Non è possibile inviare i dettagli errore al supporto Pancake perché non si è loggati.",
    "error:unknown_error_reporting" => "Si è verificato un errore sconosciuto. Si prega di segnalare questo errore manualmente.",
    "error:sending_details" => "Invio Dettagli...",
    "error:response_will_be_sent_to_email" => "Riceverai una notifica di risposte a {email}.",
    "settings:errors_and_diagnostics" => "Errori e Diagnostica",
    "error:already_reported" => "Questo errore è già stato segnalato al Supporot Pancake.",
    "error:title" => "Errore Sconosciuto",
    "error:subtitle" => "Si è verificato un errore sconosciuto.",
    "error:not_logged_in_intro" => "Questi errori vengono registrati automaticamente.",
    "error:not_logged_in_extra" => "Se il problema persiste, si prega di contattare :1.",
    "error:logged_in_intro" => "Questi errori vengono memorizzati nella sezione Admin, in 'Settings > Errors & Diagnostics'.",
    "error:logged_in_extra" => "Clicca qui per inviare una richiesta di assistenza gratuita con i dettagli dell'errore al Supporto Pancake.",
    "error:no_logged_errors" => "Non hai errori registrati.",
    "errors:subject" => "Titolo Errore ",
    "errors:report" => "Segnala errore",
    "errors:number_of_occurrences" => "# di occorrenze",
    "global:errors" => "Errori",
    "settings:error_reported" => "Errore segnalato",
    "settings:report_error" => "Segnala Errore",
    "settings:delete_error" => "Cancella Errore",
    "global:once" => "Una volta",
    "global:twice" => "Due volte",
    "global:x_times" => ":1 volte",
    "global:occurred_times" => "Verificatosi :1",
    "settings:view_error_details" => "Vedi Dettagli Errore",
    "error:deleting" => "Eliminazione...",
    "error:reporting" => "Segnalazione...",
    "clients:noclientbodyfiltered" => "Nessuno dei nomi dei clienti inizia con ':1'.",
    "tickets:archive" => "Archivia",
    "tickets:unarchive" => "Ripristina",
    'projects:unarchive_proj' => 'Ripristina Progetto',
    'invoices:lastreoccurrence' => 'Ultima Ricorrenza: :1',
    'invoices:thisisareoccurrence' => 'Questa Fattura è una ricorrenza della fattura :1.',
    ### This was moved here from the Projects language files, which were in a separate folder.
    'projects:role_view' => 'Vedi',
    'projects:role_create' => 'Crea',
    'projects:role_edit' => 'Modifica',
    'projects:role_delete' => 'Cancella',
    'projects:role_add_task' => 'Aggiungi Attività',
    'projects:role_edit_task' => 'Modifica Attività',
    'projects:role_delete_task' => 'Cancella Attività',
    'projects:role_add_milestone' => 'Aggiungi Milestone',
    'projects:role_edit_milestone' => 'Aggiungi Milestone',
    'projects:role_delete_milestone' => 'Cancella Milestone',
    'projects:role_track_time' => 'Registra Tempo',
    "projects.title" => "Progetti",
    "projects.create.title" => "Crea Progetto",
    "projects.edit.title" => "Aggiorna Progetto",
    "projects.label.name" => "Nome:",
    "projects.label.client" => "Cliente:",
    "projects.label.due_date" => "Data Termine:",
    "projects.label.rate" => "Tariffa oraria:",
    "projects.label.description" => "Descrizione:",
    "projects.label.is_viewable" => "Visibile in area Cliente?",
    "projects.button.create" => "Crea Progetto &rarr;",
    "projects.create.succeeded" => "Il progetto è stato creato!",
    "projects.button.edit" => "Aggiorna Progetto &rarr;",
    "projects.button.delete" => "Cancellare Progetto &rarr;",
    "projects.update.succeeded" => "Il progetto è stato aggiornato!",
    "projects.delete.title" => "Sei sicuro vuoi cancellare questo progetto?",
    "times.title" => "Tempi",
    "times.create.title" => "Aggiungi tempo",
    "times.label.start_time" => "Start Tempo:",
    "times.label.end_time" => "Fine Tempo:",
    "times.label.date" => "Data:",
    "times.label.task_id" => "Attività:",
    "times.label.note" => "Nota:",
    "times.label.notes" => "Note:",
    "times.button.create" => "Aggiungi tempo &rarr;",
    "times.create.succeeded" => "Il tempo è stato inserito con successo!",
    "times.edit.succeeded" => "Il tempo è stato modificato con successo!",
    # End v4.7.0 changes
    # Begin v4.7.1 changes
    "global:estimates_unsent" => "Non Inviato",
    # End v4.7.1 changes
    # Begin v4.7.3 changes
    "error:not_enough_disk_space" => "Non c'è abbastanza spazio sul disco",
    "error:cant_send_email" => "Impossibile inviare email",
    "error:not_enough_disk_space_explanation" => "Il tuo database server (:1) non ha abbastanza spazio sul disco.",
    "error:you_cannot_report_this_error" => "Non è possibile segnalare il problema al supporto Pancake, perché si tratta di un problema con il server. Si prega di contattare l'amministratore del server al riguardo. Quando discuterai la questione, riferisci loro:",
    "error:not_enough_disk_space_solutions" => "Se si ha accesso root al server del database, prova a cancellare /tmp. Se questo non funziona, controllare l'utilizzo dello spazio disco del server di database, e provare a liberare dello spazio.",
    "error:cant_send_email_explanation" => "Hai specificato di voler utilizzare Sendmail (:1) per inviare email, ma non è stato possibile farlo. É possibile che il percorso verso Sendmail sia errato o che si sia verificato un errore inaspettato.",
    "error:email_settings_not_valid" => "Le impostazioni di posta elettronica non sono valide.",
    "error:cant_send_email_solutions" => "Se si ha accesso root al server, fare in modo di avere Sendmail installato e provare a trovarlo con <code> which sendmail </code>.",
    # End v4.7.3 changes
    # Begin v4.7.5 changes
    "error:server_error" => "Errore del Server",
    "error:xcache_extension_broken" => "Il server ha un problema con l'estensione XCache.",
    "error:xcache_extension_broken_explanation" => "Qualcosa non ha funionato mentre il server tentava di caricare l'estensione XCache. Questo non è legato a Pancake, ma ne impedisce l'esecuzione.",
    "error:permissions_not_valid" => "C'è un problema con i permessi dei file sul server.",
    "error:no_tmp_dir_permissions_explanation" => "La configurazione del server non consente a Pancake di creare file temporanei in <code>:1</code>.",
    "error:no_tmp_dir_permissions_solutions" => "Se si ha accesso root al server, è possibile modificare l'impostazione <code>open_basedir</code> nel php.ini in modo che <code>:1</code> sia incluso nella lista delle cartelle consentite.",
    # End v4.7.5 changes
    # Begin v4.7.7 changes
    "error:cant_php_mail_explanation" => "È stato specificato che si desidera utilizzare PHP mail() per inviare e-mail, ma questo metodo di invio non funziona correttamente sul tuo server. Questo metodo di invio di email non richiede una configurazione, ma non è consigliabile perché i server di posta elettronica non sono in grado di verificare chi è il mittente della email. Alcuni di loro segnaleranno persino le email come spam, in automatico. Cambia le impostazioni del server di posta elettronica in Amministrazione, sotto 'Impostazioni> Emails', per utilizzare una delle opzioni SMTP, o, se non è possibile, utilizzare l'opzione Sendmail come ultima risorsa. Se nessuna opzione funziona, è necessario contattare l'amministratore del server.",
    "invoices:see_payment_schedule_below" => "Vedi sotto la Tabella Pagamenti",
    "invoices:see_payment_schedule" => "Vedi Programma Pagamenti",
    'partial:partialpayments' => 'Programma Pagamenti',
    'partial:amountlefttobeadded' => "Importo rimasto da aggiungere al programma di pagamento",
    'partial:amounttoobig' => "Importo che deve essere rimosso dal programma di pagamento",
    'partial:noamountneeded' => "Il tuo programma di pagamento è completo.",
    'partial:wrongtotal' => 'La somma di tutte le parti del vostro programma di pagamento non corrisponde all\'importo totale che si sta fatturando.',
    'partial:problemsaving' => 'Un problema si è verificato durante il salvataggio del programma dei pagamenti. Riprova.',
    'partial:wrongtotalbutsaved' => 'La somma di tutte le parti del vostro programma di pagamento non corrisponde all\'importo totale che si sta fatturando. <br /> Le modifiche alla fattura sono state salvate, ma è necessario correggere il tuo programma di pagamento.',
    'partial:problemsavingbutsaved' => 'Un problema si è verificato durante il salvataggio del programma dei pagamenti. Riprova.<br />Le modifiche alla fattura sono state salvate, mentre il programma dei pagamenti no.',
    'partial:addanother' => 'Aggiungi un\'altra voce al programma di pagamento',
    'partial:disabledforrecurring' => 'Le fatture ricorrenti sono abilitate solo al pagamento unico',
    'partial:partpaidthanks' => "Questa parte del vostro programma di pagamento fatture è stato pagato. Grazie.",
    "error:page_not_found" => "Page Not Found",
    "error:page_does_not_exist" => "La pagina a cui stavi tentando di accedere non esiste.",
    "error:page_does_not_exist_explanation" => "Si è tentato l'accesso a :1, ma questa risorsa non esiste. Se l'errore è inaspettato, è possibile segnalarlo al supporto Pancake. Lo troverete in 'Impostazioni> Errori e Diagnostica'.",
    # End v4.7.7 changes
    # Begin v4.7.8 changes
    "settings:importedcredit_notes" => "Importate Note di Credito :1 con successo.",
    # End v4.7.8 changes
    # Begin v4.7.10 changes
    "expenses:supplier_added" => "Il fornitore è stato creato con successo.",
    # End v4.7.10 changes
    # Begin v4.7.11 changes
    'reports:per_payment_method' => 'per metodo di pagamento',
    # End v4.7.11 changes
    # Begin v4.7.12 changes
    "gateways:just_for_logging" => "Nota: Questo metodo di pagamento non influisce in alcun modo sulle fatture <br /> E presenti in modo da poter documentare i Pagamenti ricevuti via :1.",
    "projects:no_data_provided" => "Non hai inserito tutte le informazioni per poter creare un progetto da un template.",
    "projects:invalid_template" => "Non è stato selezionato un template di progetto valido.",
    "settings:test_email_subject" => "Questa è un email di prova.",
    "settings:test_email_message" => "Questo è un messaggio di prova. Se lo hai ricevuto, significa che Pancake elabora correttamente le email.",
    "settings:send_test_email" => "Invia Test Email",
    "settings:sending" => "Invio email...",
    "settings:test_email_sent" => "Inviato a :1 con successo!",
    "settings:test_email_error_header" => "Errore durante l'invio email di prova",
    "settings:test_email_error" => "Si è verificato un errore durante il tentativo di inviare il messaggio di prova: <br /> <br />: 1 <br /> <br /> Assicurarsi che i dettagli inseriti siano corretti. Se si sta utilizzando il protocollo SMTP, verificare che la porta si sta tentando di utilizzare sia aperta nel firewall del server.",
    "settings:test_email_connection_error" => "Il server non può collegarsi a :1 sulla porta :2. Occorre contattare l'amministratore di sistema e approvare l'utilizzo di questa porta nel firewall del server.<br /><br />Il messaggio di errore è:<br /><br />:3",
    # End v4.7.12 changes
    # Begin v4.8.0 changes
    # Deleted "global:greetings"
    "invoices:all_unpaid" => "Tutti gli Insoluti",
    'items:select_flat_rate' => 'Forfait',
    'kitchen:no_tickets_created' => "Nessun tickets creato.",
    'kitchen:responses' => "Risposte",
    'kitchen:x_responses' => ":1 Risposte",
    'projects:add_new_task' => "Aggiungi Nuova Attività",
    'projects:delete_project_template' => "Cancella Template Progetto",
    "expenses:supplier_edited" => "Il fornitore è stato modificato con Successo.",
    "global:show_hide_deleted" => "Mostra / Nascondi eliminati",     //is °deleted° here for a single or multiple items?
    "expenses:supplier_name" => "Nome Fornitore",
    "expenses:category_name" => "Nome Categoria",
    "expenses:category_edited" => "Categoria Modificata con Successo.",
    "expenses:before_you_can_add_expenses" => "Prima di poter aggiungere delle spese è necessario creare qualche :1 e :2.",
    "reminders:no_due_date" => "No Data Termine",
    "reminders:x_days_past_due" => ":1 giorni di arretrato",
    "search:results_for_x" => 'Resultati Ricerca per ":1"',
    "search:one_matching_result" => "1 risultato corrispondente",
    "search:x_matching_results" => ":1 risultati corrispondenti",
    'global:project_expense' => 'Spesa',
    'global:project_task' => 'Attività',
    'global:ticket' => 'Ticket',
    'tickets:added' => "Il ticket è stato creato con successo.",
    'tickets:replied' => "La vostra risposta al biglietto è stata salvata con Successo.",
    'tickets:user_updated_ticket' => ":1 aggiornato lo stato del biglietto a :2 in :3",
    "global:reply" => "Rispondi",
    'global:attach_file' => "Allega file (Dimensione Massima: :1)",
    "global:download_csv" => "Scaricare CSV",
    "reports:uncollected" => "Non Raccolto",
    "reports:collected" => "Raccolto",
    "clients:filter_clients" => "Filtra Clienti",
    "users:deactivate" => "Disattiva",
    "users:activate" => "Attiva",
    "global:group" => "Grouppo",
    "users:edit_user" => "Modifica Utente",
    "users:please_enter_information" => "Si prega di inserire le informazioni dell'utente sotto.",
    "users:confirm_password" => "Conferma Password",
    "invoices:not_associated_with_a_project" => "-- Non associato con un progetto --",
    "global:by_x_with_time" => "Da :1, :2.",
    "tasks:add_notes" => "Aggiungi note",
    "tasks:complete_this_task" => "Completa questa attività",
    "tasks:task_notes" => "Note Attività",
    "tasks:discuss_task" => "Discuti Attività",
    "tickets:leave_a_response" => "Lascia una risposta",
    "tickets:active_tickets" => "Tickets Attivi",
    "projects:rate_type" => "Tipo tariffa",
    "projects:hourly_rate" => "Tariffa Oraria",
    "global:bcc_was_sent_to" => "Questa email è stata inviata a :1 il :2.",
    "global:server_default" => "Predefiniti del Server (non consigliata)",
    "error:fixed_in_version" => "Questo problema è stato risolto in Pancake {version}. Se non lo avete ancora fatto, aggiornate Pancake.",
    "error:no_user_found" => "La chiave di licenza non è associata a nessun utente in pancakeapp.com, perciò il vostro errore non può essere inviato automaticamente. Se questo errore è inaspettato, inviare una email a support@pancakeapp.com e ti aiuteremo.",
    "error:already_being_dealt_with" => "Questo problema è già stato segnalato da qualcun altro, ed è in corso di esame. Stiamo lavorando per risolverlo il più rapidamente possibile.",
    # End v4.8.0 changes
    # Begin v4.8.8 changes
    "error:php_outdated" => "La versione di PHP che si sta utilizzando non è aggiornata.",
    "error:using_php_53" => "Si sta utilizzando PHP 5.3, che è stato dichiarato obsoleto dal luglio 2013 e non è più supportato dal gruppo PHP.",
    "error:pancake_will_stop_supporting_it" => "Pancake potrebbe interrompere il supporto in qualsiasi momento.",
    "error:using_php_54" => "Si sta utilizzando PHP 5.4, che è stato dichiarato obsoleto dal Settembre 2014 e non è più supportato dal gruppo PHP.",
    "error:why_update" => "Rimanendo con questa versione di PHP, vi state perdendo una serie di miglioramenti delle prestazioni e della sicurezza, nonché una serie innumerevole di bugfixes.",
    "error:upgrade_php" => "Si dovrebbe aggiornare la versione di PHP ad almeno :1 (idealmente :2). Per fare ciò, si prega di parlare con i tuoi amministratori di server e chiedere loro di aggiornare il PHP.",
    "error:scan_pancake" => "Effettua la scansione del Pancake per problemi relativi ai file",
    "error:scan_pancake_explanation" => "A volte i problemi possono verificarsi a causa di un aggiornamento non riuscito, o a causa di problemi di autorizzazioni che causano il danneggiamento dei file di Pancake. Utilizzare questo strumento per controllare la presenza di tali problemi.",
    "error:scanning" => "Scansione in corso ...attendere prego",
    "error:unknown_error_scanning" => "Si è verificato un errore sconosciuto durante la scansione.",
    "error:scan" => "Scansiona",
    "error:scan_result_success" => "Il vostro Pancake è in perfette condizioni e non è stato alterato in alcun modo. È tutto a posto.",
    "error:scan_result_failure_deleted_one" => ":1 file non esiste",
    "error:scan_result_failure_deleted_other" => ":1 files non esistono",
    "error:scan_result_failure_modified_one" => ":1 file è stato modificato",
    "error:scan_result_failure_modified_other" => ":1 files sono stati modificati",
    "error:scan_result_failure_heading" => "Ci sono problemi con i files di Pancake.",
    "error:scan_result_failure_how_to_fix" => "Per risolvere questi problemi, è necessario aggiornare manualmente i files di Pancake.",
    "error:click_here_for_instructions" => "Clicca qui per le istruzioni",
    # End v4.8.8 changes
    # Begin v4.8.10 changes
    "error:and_x_others" => "... e :1 altri.",
    # End v4.8.10 changes
    # Begin v4.8.11 changes
    "global:archive" => "Archivio",
    "global:archived" => "Archiviato",
    "global:restore" => "Ripristina",
    "proposals:archived" => "Hai archiviato Proposta #:1 con successo.",
    "proposals:restored" => "Hai ripristinato proposta #:1 con successo.",
    "invoices:archived" => "Hai archiviato Fattura #:1 con successo.",
    "invoices:restored" => "Hai ripristinato Fattura #:1 con successo.",
    "estimates:archived" => "Hai archiviato Preventivo #:1 con successo.",
    "estimates:restored" => "Hai ripristinato Preventivo #:1 con successo.",
    "credit_notes:archived" => "Hai archiviato Nota di Credito #:1 con successo.",
    "credit_notes:restored" => "Hai ripristinato Nota di Credito #:1 con successo.",
    "proposals:list_all" => "Tutte le Proposte",
    "proposals:list_accepted" => "Proposte Accettate",
    "proposals:list_rejected" => "Proposte Respinte",
    "proposals:list_unanswered" => "Proposte senza Risposta",
    "proposals:list_archived" => "Proposte Archiviate",
    "invoices:credit_notes_archived" => "Note di Credito Archiviate",
    "invoices:estimates_archived" => "Preventivi Archiviate",
    "invoices:invoices_archived" => "Fatture Archiviate",
    # End v4.8.11 changes
    # Begin v4.8.19 changes
    "estimates:estimates_unsent" => "Preventivi non inviati",
    "tickets:invoice_for_ticket" => "Ticket #:1 - :2",
    "tickets:link_to_ticket" => "Collegamento al Ticket: :1",
    "dashboard:outstanding_invoices" => 'Fatture in Sospeso',
    "dashboard:view_all_outstanding_invoices" => "Vedi tutti le Fatture in Sospeso",
    # End v4.8.19 changes
    # Begin v4.8.24 changes
    "expenses:missing_supplier" => "Non hai selezionato un fornitore.",
    "expenses:missing_category" => "Non hai selezionato una categoria.",
    # End v4.8.24 changes
    # Begin v4.8.29 changes
    "error:update_system" => "Errore di aggiornamento",
    "error:update_system_cannot_update_file" => "Pancake non è stato in grado di modificare uno o più dei suoi file durante l'aggiornamento.",
    "error:update_system_cannot_update" => "Pancake non è stato in grado di scaricare correttamente l'aggiornamento.",
    "error:update_system_solutions" => "Non è stato possibile completare l''aggiornamento, ed è probabile che Pancake sia adesso uno stato parzialmente aggiornato, che genererà errori. É necessario aggiornare manualmente i files di Pancake per risolvere il problema. <br /><br /> :1 <br /><br /> Questi errori possono verificarsi a causa di un problema con i permessi dei file. Se Pancake non dispone di accesso in scrittura a tutti i suoi file, non è in grado di aggiornarsi correttamente. Nella maggior parte dei server, questo viene gestito automaticamente, ma un numero ristretto di server potrebbe richiedere un intervento manuale.",
    "error:update_without_ftp" => "Se non si ha accesso FTP (o non si vuole usare FTP), ma si ha accesso SSH a Pancake, <a href='https://www.pancakeapp.com/faq/update-without-ftp' target='_blank' class='blue-btn'>clcca qui</a>per imparare come aggiornare senza FTP.",
    # End v4.8.29 changes
    # Begin v4.8.30 changes
    "proposals:missing_client" => "Non hai selezionato un Cliente.",
    # End v4.8.30 changes
    # Begin v4.8.48 changes
    "gateways:direct_debit" => "Addebito Diretto",
    "error:no_permissions_explanation" => "Pancake non dispone dell'autorizzazione per creare file in <code>:1</code>.",
    "error:no_permissions_solutions" => "È possibile risolvere rendendo scrivibile la cartella. In genere, questo è fatto con CHMOD 0777, ma ci possono essere altri modi per farlo (ad esempio, tramite il pannello di controllo del web hosting).",
    "error:you_cannot_report_this_non_server_error" => "Non si può segnalare la questione al supporto Pancake perché questo non è un problema con Pancake.",
    # End v4.8.48 changes
    # Begin v4.8.50 changes
    "settings:currency_format" => "Formato Valuta",
    "settings:decimal_places" => ":1 posizioni decimali",
    # End v4.8.50 changes
    # Begin v4.8.53 changes
    "settings:no_notify_email" => "Non si dispone di un indirizzo email impostato per la tua <a href=':1'> identità aziendale </a>. <br /> Pancake non è in grado di inviare e-mail.",
    # End v4.8.53 changes
    # Begin v4.10.2 changes
    "settings:add_another_business" => "Aggiungi un altro business",
    # End v4.10.2 changes
    # Begin v4.11.6 changes
    'global:auto_send_needs_pancake_cron_job' => 'Per inviare automaticamente le fatture, è necessario configurare <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Pancake Cron Job</a>.',
    'global:you_need_pancake_cron_job' => 'Per utilizzare le fatture ricorrenti, è necessario configurare <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Pancake Cron Job</a>.',
    'settings:always_autosend' => "Auto inviare fatture per default",
    'settings:send_x_days_before_explain' => "Numero predefinito di giorni prima della scadenza fattura per effettuare invio automatico al Cliente.",
    # End v4.11.6 changes
    # Begin v4.12.0 changes
    "invoice:description" => "Descrizione",
    "invoices:charge_when_due" => "Addebita alla scadenza",
    "invoices:auto_charge" => "Addebita Cliente automaticamente",
    "invoices:pancake_will_charge_when_invoice_is_due" => "Pancake effettuerà automaticamente l'addebito a questo Cliente alla scadenza della Fattura, utilizzando i dati di pagamento salvati.",
    "invoices:pancake_cannot_auto_charge" => "Non ci sono dettagli di pagamento salvati per questo Cliente, quindi Pancake non può effettuare l'addebito automatico. Il cliente deve pagare l'utente attraverso Stripe almeno una volta, per poter salvare i relativi dettagli di pagamento.",
    "invoices:auto_charge_needs_pancake_cron_job" => 'Per addebitare automaticamente i clienti, è necessario impostare <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Pancake Cron Job</a>.',
    "global:or" => "o",
    "invoices:could_not_auto_charge" => "Pancake non è stato in grado di addebitare il vostro Cliente automaticamente. Il vostro cliente dovrà pagare la fattura #:1 manualmente.",
    "invoices:auto_charged" => "Il tuo cliente è stato addebitato per la fattura #:1. La fattura è ora pagata.",
    "settings:gmail_setup_successfully" => "È stato collegato Pancake con il tuo account Gmail con Successo!",
    "settings:pancake_uses_our_servers" => "Nota: Pancake utilizza i server Pancake per assicurarsi che il permesso di utilizzare Gmail non scada <br /> Nessun tipo di informazioni viene memorizzato. Se hai il tuo account sviluppatore Google, puoi <a target='_blank' href='https://www.pancakeapp.com/faq/google-oauth'> utilizzare il tuo server</a>.",
    "settings:you_are_signed_in" => "You are signed in as :1.<br />Fai clic sul pulsante sottostante se necessiti aggiornare i dati personali o utilizzare un account diverso.",
    "settings:you_are_using_old_auth" => "Pancake sta attualmente inviando email come :1 utilizzando la tua email e la password <br /> Fai clic sul pulsante qui sotto per effettuare l'aggiornamento ad un modo più sicuro di utilizzare Gmail.",
    "invoices:send_now" => "Invia Fattura",
    "credit_notes:messageupdated" => "La Nota di Credito è stata aggiornata!",
    'credit_notes:resend' => 'Reinvia Nota di Credito',
    "global:support" => "Aiuto / Supporto",
    "settings:filesystem" => "Dove memorizzare gli upoloads",
    "settings:filesystem_local" => "Cartelle degli Uploads",
    "filesystem:s3_access_key" => "Access Key",
    "filesystem:s3_secret_key" => "Secret Key",
    "filesystem:s3_prefix" => "Cartella (opzionale)",
    "filesystem:s3_bucket" => "S3 Bucket",
    "invoices:amount_due" => "Importo Dovuto",
    "invoices:due_date" => "Data Termine",
    "settings:filesystem_explain" => "Nota: Se si modifica questa impostazione, Pancake copierà tutti i file nel nuovo luogo di deposito per te. Non avrai bisogno di fare nient'altro.",
    # End v4.12.0 changes
    # Begin v4.12.1 changes
    "error:using_old_php" => "Si sta utilizzando PHP :1, che è stato dichiarato obsoleto dal :2 e non è più supportato dal Gruppo PHP.",
    # End v4.12.1 changes
);
/** End of file: pancake_lang.php **/